package com.cku.oa.activity.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.activity.service.SysMemberActivityRecordService;

/**
 * 会员续费参与活动记录Controller
 * @author Sunny
 * @version 2019-12-05
 */
@Controller
@RequestMapping(value = "${adminPath}/activity/sysMemberActivityRecord")
public class SysMemberActivityRecordController extends BaseController {

	@Autowired
	private SysMemberActivityRecordService sysMemberActivityRecordService;
	
	@ModelAttribute
	public SysMemberActivityRecord get(@RequestParam(required=false) String id) {
		SysMemberActivityRecord entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = sysMemberActivityRecordService.get(id);
		}
		if (entity == null){
			entity = new SysMemberActivityRecord();
		}
		return entity;
	}
	
	@RequiresPermissions("activity:sysMemberActivityRecord:view")
	@RequestMapping(value = {"list", ""})
	public String list(SysMemberActivityRecord sysMemberActivityRecord, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysMemberActivityRecord> page = sysMemberActivityRecordService.findPage(new Page<SysMemberActivityRecord>(request, response), sysMemberActivityRecord); 
		model.addAttribute("page", page);
		return "oa/activity/sysMemberActivityRecordList";
	}

	@RequiresPermissions("activity:sysMemberActivityRecord:view")
	@RequestMapping(value = "form")
	public String form(SysMemberActivityRecord sysMemberActivityRecord, Model model) {
		model.addAttribute("sysMemberActivityRecord", sysMemberActivityRecord);
		return "oa/activity/sysMemberActivityRecordForm";
	}

	@RequiresPermissions("activity:sysMemberActivityRecord:edit")
	@RequestMapping(value = "save")
	public String save(SysMemberActivityRecord sysMemberActivityRecord, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysMemberActivityRecord)){
			return form(sysMemberActivityRecord, model);
		}
		sysMemberActivityRecordService.save(sysMemberActivityRecord);
		addMessage(redirectAttributes, "保存会员续费参与活动记录成功");
		return "redirect:"+Global.getAdminPath()+"/activity/sysMemberActivityRecord/?repage";
	}
	
	@RequiresPermissions("activity:sysMemberActivityRecord:edit")
	@RequestMapping(value = "delete")
	public String delete(SysMemberActivityRecord sysMemberActivityRecord, RedirectAttributes redirectAttributes) {
		sysMemberActivityRecordService.delete(sysMemberActivityRecord);
		addMessage(redirectAttributes, "删除会员续费参与活动记录成功");
		return "redirect:"+Global.getAdminPath()+"/activity/sysMemberActivityRecord/?repage";
	}

}