//牵犬师活动报名
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //活动类型
        me.activity = ko.observable({});
        //培训学校列表
        me.schoolList = ko.observable([]);
        //级别：A;B;C默认为A
        me.showLevel = ko.observable("A");
        //培训机构
        me.schoolNameCn = ko.observable("");
        //头像id
        me.avatar = ko.observable("1");
        //桌面审查犬
        me.desktopReviewerDog = ko.observable("");
        //地面审查犬
        me.floorReviewerDog = ko.observable("");
        //选择的学校
        me.schoolText = ko.observable("请选择");
        //任意品种
        me.anyBreed = ko.observable("");
        //照片要求的显隐 默认隐
        me.pictureI = ko.observable(false);
        //照片要求的显隐事件
        me.isPicture = function(){
            me.pictureI(!me.pictureI());
        }
        //teacher提示框的显隐 默认隐
        me.isTeacher = ko.observable(false);
        //teacher提示框的显隐事件
        me.noLevel = function(){
            me.isTeacher(!me.isTeacher());
        }
        //三个犬种的显隐 默认都是显；
        me.isDesktopReviewerDog = ko.observable(true);
        me.isFloorReviewerDog = ko.observable(true);
        me.isAnyBreed = ko.observable(true);
        //教育机构的显隐 默认隐
        me.isSchoolNameCn = ko.observable(false);
        //教育机构的显隐事件
        me.showSchoolNameCn = function(){
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        /**
         * 获取活动类型
         */
        var data = util.getQueryString();
        var type = data.showType;
        me.activity().type = type;
        /**
         *选择级别
         */
        me.witchLevel = function(type){
            $("#showLevel a").removeAttr("class");
            $("#"+type).attr("class","checked");
            if(type=="levelA"){
                me.showLevel("A");
                me.isDesktopReviewerDog(true);
                me.isFloorReviewerDog(true);
                me.isAnyBreed(true);
                me.isTeacher(false);
            }else if(type=="levelB"){
                me.showLevel("B");
                me.isDesktopReviewerDog(true);
                me.isFloorReviewerDog(true);
                me.isAnyBreed(false);
                me.isTeacher(false);
            }else if(type=="levelC"){
                me.showLevel("C");
                me.isDesktopReviewerDog(false);
                me.isFloorReviewerDog(false);
                me.isAnyBreed(true);
                me.isTeacher(false);
            }else if(type=="levelT"){
                me.showLevel(" ");
                me.isDesktopReviewerDog(false);
                me.isFloorReviewerDog(false);
                me.isAnyBreed(false);
                me.isTeacher(!me.isTeacher());
            }
        }
        /**
         * 培训学校列表
         */
        me.getSchool = function(schoolType){
            var sendData = {};
            sendData["schoolType"] = schoolType;
            util.sendAjax({
                url:'trainschool/trainingInstitution',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.schoolList(data.list);
                    }
                }
            });
        }
        /**
         * 选择学校
         */
        me.witchShool = function(data,event){
            $("#school dd").removeAttr("class");
            $(event.target).parents("dd").attr("class","active");
            me.schoolText(data.schoolNameCn);
            me.schoolNameCn(data.schoolNameCn);
            me.isSchoolNameCn(!me.isSchoolNameCn());
            if($(event.target).text()!="请选择"){
                $("#otherSchool").val("").attr("disabled","disabled");
            }
        }
        /**
         * 提交申请
         */
        me.submitHandlerRegister = function(){
            var sendData = {};
            //获取活动id
            var data = util.getQueryString();
            var id = data.id;
            sendData["showCode"] = id;
            sendData["showLevel"] = me.showLevel();
            sendData["schoolNameCn"] = me.schoolNameCn();
            sendData["avatar"] = me.avatar();
            sendData["desktopReviewerDog"] = me.desktopReviewerDog();
            sendData["floorReviewerDog"] = me.floorReviewerDog();
            sendData["anyBreed"] = me.anyBreed();
            util.sendAjax({
                url:'handler/handlerRegister',
                data: JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("添加购物车成功！");
                        context.app.changeCart();
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        $(function(){
            me.getSchool("2");
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});