//个人 牵犬师活动报名
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        me.member = ko.observable(userInfo.getMember());
        //活动类型
        me.activity = ko.observable({});
        //培训学校列表
        me.schoolList = ko.observable([]);
        //级别：A;B;C默认为A
        me.showLevel = ko.observable("A");
        //培训机构
        me.schoolNameCn = ko.observable("");
        //头像id
        me.avatar = ko.observable("");
        //桌面审查犬
        me.desktopReviewerDog = ko.observable("");
        //地面审查犬
        me.floorReviewerDog = ko.observable("");
        //选择的学校
        me.schoolText = ko.observable("请选择");
        //任意品种
        me.anyBreed = ko.observable("");
        //照片要求的显隐 默认隐
        me.pictureI = ko.observable(false);
        //照片要求的显隐事件
        me.isPicture = function(){
            me.pictureI(!me.pictureI());
        }
        //teacher提示框的显隐 默认隐
        me.isTeacher = ko.observable(false);
        //teacher提示框的显隐事件
        me.noLevel = function(){
            me.isTeacher(!me.isTeacher());
        }
        //三个犬种的显隐 默认都是显；
        me.isDesktopReviewerDog = ko.observable(true);
        me.isFloorReviewerDog = ko.observable(true);
        me.isAnyBreed = ko.observable(true);
        //教育机构的显隐 默认隐
        me.isSchoolNameCn = ko.observable(false);
        //教育机构的显隐事件
        me.showSchoolNameCn = function(){
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        //级别的显隐 默认显
        me.isShowLevel = ko.observable(true);
        /**
         *选择级别
         */
        me.chooseShowLevel = function(showLevel){
            if(showLevel=="none"){
                me.showLevel("none");
                me.isDesktopReviewerDog(false);
                me.isFloorReviewerDog(false);
                me.isAnyBreed(true);
                me.isShowLevel(false);
            }else if(showLevel=="教师级"){
                me.showLevel("教师级");
                me.isDesktopReviewerDog(false);
                me.isFloorReviewerDog(false);
                me.isAnyBreed(false);
                me.isTeacher(!me.isTeacher());
            }else{
                me.showLevel(showLevel);
                if(showLevel=="A"){
                    me.showLevel("A");
                    me.isDesktopReviewerDog(true);
                    me.isFloorReviewerDog(true);
                    me.isAnyBreed(true);
                    me.isTeacher(false);
                }else if(showLevel=="B"){
                    me.showLevel("B");
                    me.isDesktopReviewerDog(true);
                    me.isFloorReviewerDog(true);
                    me.isAnyBreed(false);
                    me.isTeacher(false);
                }else if(showLevel=="C"){
                    me.showLevel("C");
                    me.isDesktopReviewerDog(false);
                    me.isFloorReviewerDog(false);
                    me.isAnyBreed(true);
                    me.isTeacher(false);
                }
            }
        }
        /**
         * 培训学校列表
         */
        me.getSchool = function(schoolType){
            var sendData = {};
            sendData["schoolType"] = schoolType;
            util.sendAjax({
                url:'trainschool/trainingInstitution',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        var list = data.list;
                        var obj = {"id":"0","schoolNameCn":"无"};
                        list.unshift(obj);
                        me.schoolList(list);
                    }
                }
            });
        }
        /**
         * 选择学校
         */ 
        me.witchShool = function(data,event){
            $("#school dd").removeAttr("class");
            $(event.target).parents("dd").attr("class","active");
            me.schoolText(data.schoolNameCn);
            me.schoolNameCn(data.schoolNameCn);
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        me.showExtert = function(){
        	me.schoolNameCn("");
        	$("#extert").show();
        	$("#selectSchool").hide();
        }
        /**
         * 提交申请
         */
        me.submitHandlerRegister = function(){
            var sendData = {};
            //获取活动id
            var data = util.getQueryString();
            var id = data.showCode;
            sendData["showCode"] = id;
            sendData["showLevel"] = me.showLevel();
            var schoolNameCn = me.schoolNameCn();
            if(util.isVal(schoolNameCn)==""){
                layer.msg("培训机构不能为空！");
                return;
            }
            sendData["schoolNameCn"] = me.schoolNameCn();
            sendData["avatar"] = me.member().avatar;
            sendData["desktopReviewerDog"] = me.desktopReviewerDog().trim();
            sendData["floorReviewerDog"] = me.floorReviewerDog().trim();
            sendData["anyBreed"] = me.anyBreed().trim();
            util.sendAjax({
                url:'handler/handlerRegister',
                data: JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("提交申请失败:"+json.msg);
                    }
                }
            });
        }
        $(function(){
            //牵犬师培训学校
            me.getSchool("2");
            /**
             * 获取活动类型
             */
            var data = util.getQueryString();
            var type = data.showType;
            me.activity().type = type;
            //级别
            var showLevel = data.showLevel;
            me.chooseShowLevel(showLevel);
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});