//个人美容师活动报名添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //会员信息
        me.member = ko.observable(userInfo.getMember());
        //活动类型
        me.activity = ko.observable({});
        //培训学校列表
        me.schoolList = ko.observable([]);
        //级别：A;B;C默认为A
        me.showLevel = ko.observable("A");
        //培训机构
        me.schoolNameCn = ko.observable("");
        //头像id
        me.avatar = ko.observable("");
        //比赛犬种
        me.showDogBreed = ko.observable("");
        //选择的学校
        me.schoolText = ko.observable("请选择");
        //照片要求的显隐 默认隐
        me.pictureI = ko.observable(false);
        //照片要求的显隐事件
        me.isPicture = function(){
            me.pictureI(!me.pictureI());
        }
        me.member = ko.observable(userInfo.getMember());
        //teacher提示框的显隐 默认隐
        me.isTeacher = ko.observable(false);
        //teacher提示框的显隐事件
        me.noLevel = function(){
            me.isTeacher(!me.isTeacher());
        }
        //教育机构的显隐 默认隐
        me.isSchoolNameCn = ko.observable(false);
        //教育机构的显隐事件
        me.showSchoolNameCn = function(){
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        //级别的显隐 默认显
        me.isShowLevel = ko.observable(true);
        /**
         *选择级别
         */
        me.chooseShowLevel = function(showLevel){
            if(showLevel=="none"){
                me.showLevel("none");
                me.isShowLevel(false);
            }else if(showLevel=="MASTER"){
                me.isTeacher(true);
                me.showLevel("MASTER");
            }else{
                me.showLevel(showLevel);
            }
        }
        //教师级的显隐
        me.showTeacher = function(){
            me.isTeacher( !me.isTeacher());
        }
        /**
         * 选择犬种
         */
        me.chooseDogBreed = function(type){
            $("#dogBreed a").removeAttr("class");
            $("#breed"+type).attr("class","checked");
            if(type!="N"){
                if(type=="B"){
                    me.showDogBreed("比熊");
                }else if(type=="G"){
                    me.showDogBreed("贵宾");
                }else if(type=="X"){
                    me.showDogBreed("雪纳瑞");
                }
                $("#otherBreed").attr("disabled","disabled").val(" ");
            }else{
                $("#otherBreed").removeAttr("disabled");
            }
        }
        /**
         * 培训学校列表
         */
        me.getSchool = function(schoolType){
            var sendData = {};
            sendData["schoolType"] = schoolType;
            util.sendAjax({
                url:'trainschool/trainingInstitution',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        var list = data.list;
                        var obj = {"id":"0","schoolNameCn":"无"};
                        list.unshift(obj);
                        me.schoolList(list);
                    }else{
                        layer.msg("获取学校列表失败："+data.msg);
                    }
                }
            });
        }
        /**
         * 选择学校
         */
        me.witchShool = function(data,event){
            $("#school dd").removeAttr("class");
            $(event.target).parents("dd").attr("class","active");
            me.schoolText(data.schoolNameCn);
            me.schoolNameCn(data.schoolNameCn);
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        me.showExtert = function(){
        	me.schoolNameCn("");
        	$("#extert").show();
        	$("#selectSchool").hide();
        }
        /**
         * 提交申请
         */
        me.submitHandlerRegister = function(){
            var sendData = {};
            //获取活动id
            var data = util.getQueryString();
            var showCode = data.showCode;
            sendData["showCode"] = showCode;
            sendData["showLevel"] = me.showLevel();
            sendData["schoolNameCn"] = me.schoolNameCn();
            var schoolNameCn = me.schoolNameCn();
            if(util.isVal(schoolNameCn)==""){
                layer.msg("培训机构不能为空！");
                return;
            }
            sendData["avatar"] = me.member().avatar;
            sendData["showDogBreed"] = me.showDogBreed();
            util.sendAjax({
                url:'groomer/groomerRegister',
                data: JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("提交申请失败:"+json.msg);
                    }
                }
            });
        }
        $(function(){
            //美容师培训学校
            me.getSchool("1");
            /**
             * 获取活动类型
             */
            var data = util.getQueryString();
            var showType = data.showType;
            me.activity().type = showType;
            //级别
            var showLevel = data.showLevel;
            me.chooseShowLevel(showLevel);
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});

