<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function chipForm(id){
 			parent.layer.open({
				type: 2,
				title: ['芯片', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '300px'],
				scrollbar: false,
				content: ['${ctxPartner}'+"/clubMember/dogCertifiedChangeChipYesForm?id="+id,'no'],
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		function DNAForm(msg){
			layer.msg(msg);
		}  
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="dogPedigreeCertifiedChange" action="${ctxPartner}/hospital/dogPedigreeCertifiedChangelist" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>国外血统证号：</label>
				<form:input path="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>国外血统证书编号</th>
				<th>CKU血统证书编号</th>
				<th>芯片号</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>审核状态</th>
				<th>是否采集DNA</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogPedigreeCertifiedChange">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
				</td>
				<td>
					<c:choose>
					<c:when test="${fns:startsWith(dogPedigreeCertifiedChange.overseasPedigreeCertified,'CKU')}">
								${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
					</c:when>
					<c:otherwise>
								${fns:escapeHtml(dogPedigreeCertifiedChange.pedigreeCertifiedCode)}
					</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogChip)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.breedCnName)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogBreed)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td style="color:#000" title="${fns:escapeHtml(dogPedigreeCertifiedChange.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedChange.paymentState=='2'}">
						${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}
						<img  src="${ctxStatic}/images/showReason.png" onclick="DNAForm('${fns:escapeHtml(dogPedigreeCertifiedChange.reviewRemarks)}')">
					</c:if>
					
				</td>
				<td>
					<c:if test="${empty dogPedigreeCertifiedChange.dogDnaArchiveId}">
						<font color="#F00">否</font>
					</c:if>
					<c:if test="${not empty dogPedigreeCertifiedChange.dogDnaArchiveId}">
						<font color="#090">是</font>
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${empty dogPedigreeCertifiedChange.dogChip }">
							<a href="${ctxPartner}/hospital/dogCertifiedChangeChipForm?id=${dogPedigreeCertifiedChange.id}">芯片</a>
						</c:when>
						<c:when test="${not empty dogPedigreeCertifiedChange.dogChip && dogPedigreeCertifiedChange.dogChipCheck=='0'}">
							<a href="#" onclick="chipForm('${dogPedigreeCertifiedChange.id}')">芯片</a>
						</c:when>
						<c:otherwise>
							<font>芯片</font>
						</c:otherwise>
					</c:choose>
					<c:choose>
						<c:when test="${empty dogPedigreeCertifiedChange.dogDnaArchiveId && dogPedigreeCertifiedChange.dogChipCheck=='1'}">
							<a style="color:red;"  href="${ctxPartner}/hospital/dogCertifiedChangeDNAForm?id=${dogPedigreeCertifiedChange.id}">采集DNA</a>
						</c:when>
						<c:when test="${not empty dogPedigreeCertifiedChange.dogDnaArchiveId}">
							<font style="color:green;">采集DNA</font>
						</c:when>
					</c:choose>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>