<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>大客户进度统计</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		    $("#btnExport").click(function () {
                var memberCode = $("#memberCode").val();
                var manInCharge = $("#manInCharge").val();
                var endDate = $("#endDate").val();
                var url = "/oa-web/oaManage/statistics/memberVip/exportScheduleStat?memberCode="+memberCode+"&manInCharge="+manInCharge+"&endDate="+endDate;
                $("#btnExport").attr("href",url);
            });
		});

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/statistics/memberVip/scheduleStat">大客户进度统计</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="memberVip" action="${ctx}/statistics/memberVip/scheduleStat" method="post" class="breadcrumb form-search">
		<li class="ul-form">
            <li><label>会员号：</label>
                <form:input path="memberCode" htmlEscape="false" maxlength="16" class="input-medium"/>
            </li>
            <li><label>截止日期：</label>
                <input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                       value="<fmt:formatDate value="${memberVip.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                       onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            </li>
            <li><label>客户经理：</label>
                <form:input path="manInCharge" htmlEscape="false" maxlength="16" class="input-medium"/>
            </li>
            <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns">
			<a id="btnExport" class="btn btn-primary">
				导出
			</a>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员姓名</th>
				<th>会员号</th>
				<th>客户类型</th>
				<th>客户经理</th>
				<th>签约日期</th>
				<th>签约数量</th>
				<th>完成数量</th>
				<th>完成比例</th>
				<%--<th>母犬配种证明</th>--%>
				<%--<th>母犬配种证明收入</th>--%>
				<%--<th>公犬配种证明</th>--%>
				<%--<th>公犬配种证明收入</th>--%>
				<%--<th>出生纸</th>--%>
				<%--<th>出生纸收入</th>--%>
				<%--<th>血统证书</th>--%>
				<%--<th>血统证书收入</th>--%>
				<%--<th>整窝办理</th>--%>
				<%--<th>整窝办理收入</th>--%>
				<%--<th>血统证书总计</th>--%>
				<%--<th>血统证书总计收入</th>--%>
				<th>新会员数量</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${memberVipList}" var="memberVip">
			<tr>
				<td>${fns:escapeHtml(memberVip.memberName)}</td>
				<td>${fns:escapeHtml(memberVip.memberCode)}</td>
				<td>${fns:getDictLabel(memberVip.contractType, 'contract_type', '')}</td>
				<td>${fns:escapeHtml(memberVip.manInCharge)}</td>
				<td><fmt:formatDate value="${memberVip.startDate}" pattern="yyyy-MM-dd"/></td>
				<td>${fns:escapeHtml(memberVip.contractNum)}</td>
				<td>${fns:escapeHtml(memberVip.pedigreeCertifiedCompleteNum)}</td>
				<td>${fns:escapeHtml(memberVip.pedigreeCertifiedCompleteRatio)}</td>
				<td>${fns:escapeHtml(memberVip.memberCount)}</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>