<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerRegister/viewExaminer?id=${handlerRegister.id}">报名信息查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerRegister"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.registerCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
			${fns:getDictLabel(handlerRegister.gender, 'user_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.mobile)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">品种：</label>
			<div class="controls">
					${fns:escapeHtml(handlerRegister.anyBreed)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.schoolNameCn)}
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>活动信息</h3>	
		<div class="control-group">
			<label class="control-label">活动编号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.showCode)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动类别：</label>
			<div class="controls">
				${fns:getDictLabel(handlerRegister.handlerShow.showType, 'handler_show_type', '')}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动级别：</label>
			<div class="controls">
			${ handlerRegister.showLevel}
			<c:if test="${ handlerRegister.handlerShow.showType eq '10' } ">
				${fns:getDictLabel(handlerRegister.showLevel, 'handler_test_level_examiner', '')}
			</c:if>
			<c:if test="${ handlerRegister.handlerShow.showType eq '11'} ">
				${fns:getDictLabel(handlerRegister.showLevel, 'groomer_examiner_course_level', '')}
			</c:if>
			</div>
		</div>
		
		<c:if test="${handlerRegister.showLevel eq '4' || handlerRegister.showLevel eq '7'}">
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<form:checkboxes onclick="return false;"  path="showGroups" items="${fns:getDictList('handler_show_group')}"  itemLabel="label" itemValue="value" htmlEscape="false"/>
			</div>
		</div>
		</c:if>
	<%-- 	<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.schoolNameCn)}
			</div>
		</div> --%>
		

		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<%-- <form:select path="reviewState" class="input-medium">
					<form:option value="1" label="已报名"/>
					<form:option value="3" label="已取消"/>
				</form:select> --%>
					<c:if test="${handlerRegister.reviewState eq '0'}">
						待审核
					</c:if>
					<c:if test="${handlerRegister.reviewState eq '1'}">
						通过
					</c:if>
					<c:if test="${handlerRegister.reviewState eq '2'}">
						未通过
					</c:if>
					<c:if test="${handlerRegister.reviewState eq '3'}">
						已注销
					</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.fee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
					${fns:escapeHtml(handlerRegister.remarks) }
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>