<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容活动犬种管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShowBreeds/">美容活动犬种列表</a></li>
		<shiro:hasPermission name="groomer:groomerShowBreeds:edit"><li><a href="${ctx}/groomer/groomerShowBreeds/form">美容活动犬种添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShowBreeds" action="${ctx}/groomer/groomerShowBreeds/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>描述</th>
				<th>更新时间</th>
				<shiro:hasPermission name="groomer:groomerShowBreeds:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShowBreeds">
			<tr>
				<td><a href="${ctx}/groomer/groomerShowBreeds/form?id=${groomerShowBreeds.id}">
					${groomerShowBreeds.remarks}
				</a></td>
				<td>
					<fmt:formatDate value="${groomerShowBreeds.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="groomer:groomerShowBreeds:edit"><td>
    				<a href="${ctx}/groomer/groomerShowBreeds/form?id=${groomerShowBreeds.id}">修改</a>
					<a href="${ctx}/groomer/groomerShowBreeds/delete?id=${groomerShowBreeds.id}" onclick="return confirmx('确认要删除该美容活动犬种吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>