<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容官网轮播图管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/gcWeb/banner/">轮播图列表</a></li>
    <li class="active">
        <a href="${ctx}/gcWeb/banner/form?id=${gcWebBanner.id}">轮播图
            <shiro:hasPermission name="gcWeb:banner:edit">${not empty gcWebBanner.id?'修改':'添加'}</shiro:hasPermission>
            <shiro:lacksPermission name="gcWeb:banner:edit">查看</shiro:lacksPermission>
        </a>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="gcWebBanner" action="${ctx}/gcWeb/banner/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">标题：</label>
        <div class="controls">
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">大图：</label>
        <div class="controls">
            <c:choose>
                <c:when test="${!empty gcWebBanner.image}">
                    <img id="previewImage" src="${gcWebBanner.image}" style="padding:10px;height:130px;"/>
                </c:when>
                <c:otherwise>
                    <img id="previewImage"/>
                </c:otherwise>
            </c:choose>
            <div style="width: 300px">
                <sys:ossUpload module="gcWebBannerImage" maxCount="1" maxSize="5" successHideFile="true"
                               successCallback="uploadImageCallBack"/>
            </div>
            <form:input path="image" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            <!-- 文件上传成功的回调方法 -->
            <script type="text/javascript">
                function uploadImageCallBack(file, res) {
                    $("#image").val(res.fileUrl);
                    $("#previewImage").attr("src", res.fileUrl)
                    $("#previewImage").attr("style", "padding:10px;height:130px;");
                }
            </script>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">小图(手机适配用)：</label>
        <div class="controls">
            <c:choose>
                <c:when test="${!empty gcWebBanner.smallImage}">
                    <img id="previewSmallImage" src="${gcWebBanner.smallImage}" style="padding:10px;height:130px;"/>
                </c:when>
                <c:otherwise>
                    <img id="previewSmallImage"/>
                </c:otherwise>
            </c:choose>
            <div style="width: 300px">
                <sys:ossUpload module="gcWebBannerSmallImage" maxCount="1" maxSize="5" successHideFile="true"
                               successCallback="uploadSmallImageCallBack"/>
            </div>
            <form:input path="smallImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            <!-- 文件上传成功的回调方法 -->
            <script type="text/javascript">
                function uploadSmallImageCallBack(file, res) {
                    $("#smallImage").val(res.fileUrl);
                    $("#previewSmallImage").attr("src", res.fileUrl)
                    $("#previewSmallImage").attr("style", "padding:10px;height:130px;");
                }
            </script>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示标记：</label>
        <div class="controls">
            <form:select path="showFlag" class="input-xlarge required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false" maxlength="11" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1000" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="gcWeb:banner:edit">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>