<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬主变更编辑</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            if($("#reviewState").val()==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
            }
        });
        function closeLayer(){
            parent.isYes = false;
            parent.layer.closeAll();
        }
        function changeState(val){
             if(val==2){
                 $("#reviewDiv").show();
             } else {
                 $("#reviewDiv").hide();
                 $("#reviewRemarks").val('');
             }
        }
       //打开查询用户的弹窗
       function searchUser(){
            top.layer.open({
                type: 2,
                title: ['会员查询', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '500px'],
                content: "${ctx}/sys/user/member/search"
            });
        }
        
       //查询用户完成的回调方法
       this.searchUserCallback = function (json){
           $("#newOwnerName").val(json.name);
           $("#newOwnerMemberCode").val(json.memberCode);
       }
    </script>
</head>
<body>
    <ul class="nav nav-tabs">
        <li><a href="${ctx}/dogownerchange/dogOwnerChange/${dogOwnerChange.dog.dogBreed==230?'?dogBreed=230':''}">犬主变更申请列表</a></li>
        <li class="active"><a href="${ctx}/dogownerchange/dogOwnerChange/edit?id=${dogOwnerChange.id}">犬主变更申请<shiro:hasPermission name="dogownerchange:dogOwnerChange:edit">${not empty dogOwnerChange.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogownerchange:dogOwnerChange:edit">查看</shiro:lacksPermission></a></li>
    </ul><br/>
    <form:form id="inputForm" modelAttribute="dogOwnerChange" action="${ctx}/dogownerchange/dogOwnerChange/save" method="post" class="form-horizontal">
        <form:hidden path="id"/>
        <form:hidden path="newOwnerMemberCode"/>
        <sys:message content="${message}"/>     
        <div class="control-group">
        </div>
        <div class="control-group">
            <label class="control-label">血统证书号：</label>
            <div class="controls">
                <form:input path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">原犬主：</label>
            <div class="controls">
                <form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">新犬主：</label>
            <div class="controls">
                <form:input path="newOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
                <input id="search" class="btn btn-primary" type="button" value="查" onclick="searchUser()"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">申请日期：</label>
            <div class="controls">
                <input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                    value="<fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" disabled="disabled"/>
            </div>
        </div>
        <div class="form-actions">
            <shiro:hasPermission name="dogownerchange:dogOwnerChange:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保存"/>&nbsp;</shiro:hasPermission>
            <input id="btnCancel" class="btn" type="button" value="返回" onclick="history.go(-1)"/>
        </div>
    </form:form>
</body>
</html>