<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>用户会员信息表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/catx/member/">会员列表</a></li>
    <shiro:hasPermission name="catx:member:add">
        <li><a href="${ctx}/catx/member/addForm">添加会员</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="member" action="${ctx}/catx/member/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>会员号/姓名：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
        </li>
        <li>
            <label>电话：</label>
            <form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
        </li>
        <li>
            <label>证件号：</label>
            <form:input path="cardNo" htmlEscape="false" maxlength="100" class="input-small"/>
        </li>
        <li>
            <label>会员类型：</label>
            <form:select path="memberCardType" class="input-small">
                <form:option value="">全部</form:option>
                <form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>会员编号</th>
        <th>姓名</th>
        <th>电话</th>
        <th>安全手机</th>
        <th>会员类型</th>
        <th>缴费状态</th>
        <th>余额</th>
        <th>管理</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="member">
        <tr>
            <td>
                    ${fns:escapeHtml(member.memberCode) }
            </td>
            <td>
                    ${fns:escapeHtml(member.name)}
            </td>
            <td>
                    ${fns:escapeHtml(member.mobile)}
            </td>
            <td>
                    ${fns:escapeHtml(member.safeMobile)}
            </td>
            <td>
                    ${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
            </td>
            <td style="color:${member.paymentState=='2'?'#090':'#F00'}">
                    ${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}
            </td>
            <td>
                    ${member.accountBalance }
            </td>
            <td>
                <shiro:hasPermission name="catx:member:del">
                    <a href="${ctx}/catx/member/delete?id=${member.id}"
                       onclick="return confirmx('确认要删除该用户会员信息表吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>