/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.sys.security;

/**
 * 用户和密码（包含验证码）令牌类
 * @author ThinkGem
 * @version 2013-5-19
 */
public class UsernamePasswordToken extends org.apache.shiro.authc.UsernamePasswordToken {

	private static final long serialVersionUID = 1L;

	private String captcha;
	private boolean mobileLogin;
	private String type;
	private boolean isMD5 = false;
	private String loginType;
	
	public UsernamePasswordToken() {
		super();
	}

	public UsernamePasswordToken(String username, char[] password,String type,
			boolean rememberMe, String host, String captcha, boolean mobileLogin,String loginType) {
		super(username, password, rememberMe, host);
		this.type = type;
		this.captcha = captcha;
		this.mobileLogin = mobileLogin;
		this.loginType = loginType;
	}

	/**
	 * 仅用于手机端登录
     */
	public UsernamePasswordToken(String username, char[] password,String type,boolean rememberMe, String host, String captcha, boolean mobileLogin,boolean isMD5) {
		super(username, password, rememberMe, host);
		this.type = type;
		this.captcha = captcha;
		this.mobileLogin = mobileLogin;
		this.isMD5 = isMD5;
	}
	public String getCaptcha() {
		return captcha;
	}

	public void setCaptcha(String captcha) {
		this.captcha = captcha;
	}

	public boolean isMobileLogin() {
		return mobileLogin;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public boolean isMD5() {
		return isMD5;
	}

	public void setMD5(boolean MD5) {
		isMD5 = MD5;
	}

	public String getLoginType() {
		return loginType;
	}

	public void setLoginType(String loginType) {
		this.loginType = loginType;
	}
	
	
}