/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.sys.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 用户DAO接口
 * 
 * @author ThinkGem
 * @version 2014-05-16
 */
@MyBatisDao
public interface UserDao extends CrudDao<User> {

	/**
	 * 根据登录名称查询用户
	 * 
	 * @param loginName
	 * @return
	 */
	public User getByLoginNameAndUserType(User user);

	/**
	 * 通过名称和电话获取后台账号
	 * 
	 * @author yuanshuai
	 * @date 2021/6/16 14:30
	 */
	User getBackUserByNameAndMobile(@Param("name") String name, @Param("mobile") String mobile);

	public User getUserInfoByToken(String token);

	/**
	 * 根据邮箱查询用户
	 * 
	 * @param loginName
	 * @return
	 */
	public User getByEmailAndUserType(User user);

	/**
	 * 通过OfficeId获取用户列表，仅返回用户id和name（树查询用户时用）
	 * 
	 * @param user
	 * @return
	 */
	public List<User> findUserByOfficeId(User user);

	/**
	 * 更新用户的权限信息
	 */
	public void updatePermissions(User user);

	/**
	 * 查询全部用户数目
	 * 
	 * @return
	 */
	public long findAllCount(User user);

	/**
	 * 更新用户密码
	 * 
	 * @param user
	 * @return
	 */
	public int updatePasswordById(User user);

	/**
	 * 更新登录信息，如：登录IP、登录时间
	 * 
	 * @param user
	 * @return
	 */
	public int updateLoginInfo(User user);

	/**
	 * 删除用户角色关联数据
	 * 
	 * @param user
	 * @return
	 */
	public int deleteUserRole(User user);

	/**
	 * 插入用户角色关联数据
	 * 
	 * @param user
	 * @return
	 */
	public int insertUserRole(User user);

	/**
	 * 更新用户信息
	 * 
	 * @param user
	 * @return
	 */
	public int updateUserInfo(User user);

	/**
	 * 更新用户邮箱和手机
	 * 
	 * @param user
	 * @return
	 */
	public int updateEmailAndMobile(User user);

	/**
	 * 校验emali,手机号,证件号重复验证 增加根据userType查重，区分cku和ckudc yuanshuai-2017.12.12
	 * 
	 * @Author chaixueteng
	 * @2016年10月11日下午2:07:38
	 */
	List<User> check(@Param("param") String param, @Param("val") String val, @Param("userType") String userType);

	/**
	 *
	 * @description: 微信登录更新微信号
	 * @author: laiguanglong
	 * @date: 2016年10月23日 上午11:10:23
	 */
	public int updateWeixinId(User user);

	/**
	 *
	 * @description: 更新登录信息
	 * @author: laiguanglong
	 * @date: 2016年10月23日 上午11:10:23
	 */
	public int updateLoginFlag(User user);

	/**
	 * @Description： 修改绑定手机
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/21 10:55
	 */
	int updateBindMobile(User user);

	int updateAllMobile(User user);

	List<User> getByLoginName(@Param("loginName") String loginName);

	List<User> findByIds(@Param("idList") List<String> idList);
	
	List<User> findMemberNameByIds(@Param("idList") List<String> idList);

}
