package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.coupon.entity.SysGift;
import com.cku.oa.sys.coupon.service.SysGiftService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.sys.model.RestGift;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping(value = "/api/v1/gift")
public class RestGiftController extends BaseRestController {

	@Autowired
	private SysGiftService sysGiftService;

	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public void gifts(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
		String usestate = request.getParameter("state");
		String giftName = request.getParameter("giftName");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (org.apache.commons.lang.StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (org.apache.commons.lang.StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		SysGift sysGift = new SysGift();
		Page<SysGift> page = new Page<SysGift>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		if (StringUtils.isNotBlank(giftName)) {
			sysGift.setGiftName(giftName);
		}
		sysGift.setUsestate(usestate);
		sysGift.setMemberCode(member.getMemberCode());

		Page<SysGift> result = sysGiftService.findPage(page, sysGift);
		List<SysGift> giftList = result.getList();
		List<RestGift> list = new ArrayList<RestGift>();
		for (SysGift gift : giftList) {
			RestGift vo = new RestGift();
//			BeanUtils.copyProperties(gift, vo);
			vo.setMemberCode(gift.getMemberCode());
			vo.setGiftName(gift.getGiftName());
			vo.setGiftCode(gift.getGiftCode());
			vo.setUrl(gift.getUrl());
			vo.setSource(gift.getSource());
			vo.setFacePrice(gift.getFacePrice());
			vo.setExplains(gift.getExplains());
			vo.setUsageFlow(gift.getUsageFlow());
			vo.setUsageRule(gift.getUsageRule());
			vo.setGiftType(gift.getGiftType());
			vo.setEffectiveDate(gift.getEffectiveDate() == null ? "" : DateUtils.formatDate(gift.getEffectiveDate()));
			vo.setValidDate(gift.getValidDate() == null ? "" : DateUtils.formatDate(gift.getValidDate()));
			list.add(vo);
		}
		long count = result.getCount();
		ServletUtils.writeResponse(response, new RESTResponse("list", new PageBeanResult<RestGift>(list, count)));
	}

}
