package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.Executor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;

import org.apache.shiro.authc.AuthenticationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.SendMailUtil;

import net.sf.json.JSONException;

/**
 *
 * @author fanhuibin
 */
public class BaseRestController {
	/**
	 * 验证Bean实例对象
	 */
	@Autowired
	protected Validator validator;
	
	@Autowired
	private Executor executor;
	
	public Validator getValidator() {
		return validator;
	}

	public void setValidator(Validator validator) {
		this.validator = validator;
	}

	/**
	 * 统一的异常处理逻辑
	 * @param request request
	 * @param ex 异常
	 * @return
	 * @throws IOException 
	 */
	@ExceptionHandler
	@ResponseBody
    public void exp(HttpServletRequest request,HttpServletResponse response, Exception ex) throws IOException {  
        if(ex instanceof ZAException) {  
        	ZAException e = (ZAException)ex;
        	int code = e.get_code();
        	String message = e.getMessage();
        	RESTResponse result = new RESTResponse(code,message);
			ServletUtils.writeResponse(response, result);
        }else if(ex instanceof AuthenticationException) {  
        	RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERC_AUTHENTICATION,"认证用户信息失败");
			ServletUtils.writeResponse(response, result);
        }else if(ex instanceof IOException){
        	RESTResponse result = new RESTResponse(1,"请求发生异常");
			ServletUtils.writeResponse(response, result);
        }else if(ex instanceof JSONException){
        	RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERC_PARAM_ERROR,"请求的参数不满足要求");
			ServletUtils.writeResponse(response, result);
        }else if(ex instanceof MethodArgumentNotValidException){
        	ex.printStackTrace();
        	List<FieldError>  errors = ((MethodArgumentNotValidException) ex).getBindingResult().getFieldErrors();
        	RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERROR,errors.get(0).getDefaultMessage());
			ServletUtils.writeResponse(response, result);
        }else {
        	ex.printStackTrace();
        	RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERROR,"服务器处理数据发生异常");
			ServletUtils.writeResponse(response, result);
			String a = request.getServerName();
			executor.execute(() -> {
				if("viptest.chongaibao.com".equals(a)
						||"vip.chongaibao.com".equals(a)){
					String msg = getExceptionStack(ex);
					SendMailUtil.sendMailForError("xuxue@chongaibao.com", "异常信息通知【"+a+"】", msg);
				}
			});
        }
        
    }  
	
	
	public static String getExceptionStack(Throwable throwable) {
	    StringWriter sw = new StringWriter();
	    PrintWriter pw = new PrintWriter(sw);
	    throwable.printStackTrace(pw);
	    return sw.toString();
	}
	
	
}
