/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.handler.service.RestHandlerDiplomaService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 结业证书Controller
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "/api/v1/handler")
public class RestHandlerDiplomaController extends BaseRestController {

	@Autowired
	private RestHandlerDiplomaService restHandlerDiplomaService;
	
	@RequestMapping(value = "/handlerDiploma", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerDiplomaService.post(json);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 结业证书列表
	 * @Author chaixueteng
	 * @2016年9月25日下午3:02:22
	 */
	@RequestMapping(value = "/getHandlerDiplomaList", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerDiplomaService.getList(request);
		ServletUtils.writeResponse(response, result);
	}
}