/**
o * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogVideoAppraisalService;
import com.cku.restful.v1.dog.model.RestCheckMemberVo;
import com.cku.restful.v1.dog.model.RestDogAppraisalVo;
import com.cku.restful.v1.dog.model.RestVideoAppraisalListResponse;
import com.cku.restful.v1.dog.service.RestDogAppraisalService;
import com.cku.restful.v1.dog.vo.RestDogAppraisaRespVo;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 赛场犬只鉴定Controller
 *
 * @author lgl
 * @version 2016-07-15
 */
@Api(tags = "赛事鉴定-zxy")
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogAppraisalController extends BaseRestController {

	@Autowired
	private RestDogAppraisalService restDogAppraisalService;

	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;

	@ApiOperation(value = "赛事鉴定-列表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestDogAppraisalVo>  list(HttpServletRequest request, HttpServletResponse response) {
		return restDogAppraisalService.list(request);
	}

	@ApiOperation(value = "赛事鉴定-会员是否有效")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@RequestMapping(value = "/checkMember", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<RestCheckMemberVo> checkMember(HttpServletRequest request, HttpServletResponse response) {
		return restDogAppraisalService.checkMember(request);
	}

	@ApiOperation(value = "赛事鉴定-可申报的犬只")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "source", value = "show"),
			@ApiImplicitParam(name = "keyword", value = "芯片号，护照号") })
	@RequestMapping(value = "/getAppraisalDogs", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestVideoAppraisalListResponse> getAppraisalDogs(HttpServletRequest request, HttpServletResponse response) {
		return dogVideoAppraisalService.getList(request);
	}

	@ApiOperation(value = "赛事鉴定定-提交表单")
	@RequestMapping(value = "/dogappraisal", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<RestDogAppraisaRespVo> post(@ApiParam(name="json" , value = "{\n" + 
			"    \"mainShowId\":\"7d9689ac876c4570a87a40f93d112c61(赛事id)\",\n" + 
			"    \"dogBreed\":\"254（品种code）\",\n" + 
			"    \"dogBreedCn\":\"阿尔卑斯达切斯勃拉克犬（品种cn）\",\n" + 
			"    \"dogName\":\"xiaohei（犬名）\",\n" + 
			"    \"dogColor\":\"Pepper（颜色code）\",\n" + 
			"    \"dogColorCn\":\"Pepper-胡椒色（颜色cn）\",\n" + 
			"    \"birthday\":\"2018-09-09（犬出生日期）\",\n" + 
			"    \"dogNose\":\"noseid（鼻纹）\",\n" + 
			"    \"dogGender\":\"1（性别 1:公 2：母）\",\n" + 
			"    \"videoAppraisalId\":\"视频鉴定id\"\n" + 
			"}") @RequestBody String json, HttpServletResponse response) throws IOException {
		// 关闭接口
//        throw new ZAException(ZAErrorCode.ZA_ERROR,"此功能已关闭，如有疑问请联系CKU");
//		RESTResponse result =
//		ServletUtils.writeResponse(response, result);
		return restDogAppraisalService.post(json);
	}

	@RequestMapping(value = "/dogappraisal/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletResponse response) throws IOException {
		// 关闭接口
		throw new ZAException(ZAErrorCode.ZA_ERROR, "此功能已关闭，如有疑问请联系CKU");
//		RESTResponse result = restDogAppraisalService.getPrice();
//		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogappraisal/checkByMainShowId", method = RequestMethod.GET)
	@ResponseBody
	public void checkByMainShowId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 关闭接口
		throw new ZAException(ZAErrorCode.ZA_ERROR, "此功能已关闭，如有疑问请联系CKU");
//		RESTResponse result = restDogAppraisalService.checkByMainShowId(request);
//		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月3日 上午9:36:25
	 */
	@RequestMapping(value = "/dogappraisal/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogAppraisalService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}
}