package com.cku.partner.open.sys.web;

import com.alibaba.fastjson.JSONObject;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.SysUserLoginLogService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.partner.open.sys.service.AppLoginService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 合作机构与合作医院的用户登录
 * @author fanhuibin
 *
 */
@Controller
@RequestMapping(value="/partner/open")
@Api(value = "俱乐部登陆(PC&APP)-zhangxiang", tags = { "俱乐部登陆(PC&APP)-zhangxiang" })
public class APPLoginController {

	@Autowired
	private OrgService orgService;
	@Autowired
	private AppLoginService appLoginService;
	@Autowired
	private SysUserLoginLogService userLoginLogService;
	/**
	* @Description:
	* @author: zhangxiang
	* @date: 2020/7/10 14:03
	*/
	@ApiOperation(value = "APP合作机构登陆")
	@ApiImplicitParams({ @ApiImplicitParam(name = "username", value = "账号"),
			@ApiImplicitParam(name = "password", value = "密码")})
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "/login", method = RequestMethod.POST)
	@ResponseBody
	public Object login(@RequestBody String json, HttpServletRequest request, HttpServletResponse response){
		JSONObject params = new JSONObject();
		//登陆类型
		String loginType="appClub";
		net.sf.json.JSONObject object = net.sf.json.JSONObject.fromObject(json);
		String username = object.getString("username");
		String password = object.getString("password");
		String host = IPLimitUtil.getIpAddr((HttpServletRequest)request);
		try{
			appLoginService.login(username, password, host, loginType);

			//保存登录日志
			userLoginLogService.saveLoginLog(request);

			User user = UserUtils.getUser();
			Org org = new Org();
			org.setUser(user);
			List<Org> orgs = orgService.findList(org);
			if(orgs.size() == 1){
				if(orgs.get(0).getEndDate().getTime()<System.currentTimeMillis()){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号已经过期，请联系CKU处理");
				}
			}else{
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
			}
			params.put("rc", "0");
			params.put("org",orgs.get(0));
		}catch(Exception e){
			params.put("rc", "1");
			params.put("msg", e.getMessage());
		}
		return params;

	}

	/**
	 * @Description: 获取合作机构
	 * @author: zhangxiang
	 * @date: 2020/7/10 14:03
	 */
	@RequestMapping(value = "/org", method = RequestMethod.POST)
	@ResponseBody
	public Object org(@RequestBody String json, HttpServletRequest request, HttpServletResponse response){
		JSONObject params = new JSONObject();
		//登陆类型
		try{
			User user = UserUtils.getUser();
			Org org = new Org();
			org.setUser(user);
			List<Org> orgs = orgService.findList(org);
			if(orgs.size() == 1){
				if(orgs.get(0).getEndDate().getTime()<System.currentTimeMillis()){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号已经过期，请联系CKU处理");
				}
			}else{
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
			}
			params.put("rc", "0");
			params.put("org",orgs.get(0));
		}catch(Exception e){
			params.put("rc", "1");
			params.put("msg", e.getMessage());
		}
		return params;

	}

}
