package com.cku.partner.club.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.clubdog.dao.TcbDogChipDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.club.service.ClubDogChipService;
import com.cku.partner.club.service.ClubMemberService;
import com.cku.partner.club.service.TcbDogService;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 合作俱乐部
 *user chaixueteng
 *2016年10月8日
 */
@Controller
@RequestMapping(value="/partner/tcbDog")
public class tcbDogController  extends BaseController{
	@Autowired
	public MemberService memberService;
	@Autowired
	public  ClubMemberService clubMemberService;
	@Autowired
	public  TcbDogService tcbDogService;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public DogService dogService;
	@Autowired
	public DogChipService dogChipService;
	@Autowired
	public ClubDogChipService clubDogChipService;
	@Autowired
	public RestDogChipService restDogChipService;
	@Autowired
	public KennelDao kennelDao;
	@Autowired
	public OrgService orgService;


	
	

	/**
	 * 淘宠宝提交的新生犬
	 * @Author chaixueteng
	 * @2017年11月1日上午10:55:43
	 */
	@RequestMapping(value = "validBirthCode")
	public String validDogChip(HttpServletRequest request, HttpServletResponse response, Model model,RedirectAttributes redirectAttributes) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		String birthCode = request.getParameter("birthCode").trim();
		DogBirthCertificate birthCerRegCode = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if(birthCerRegCode==null){
			addMessage(redirectAttributes, "查询登记卡失败:登记卡编号不正确!");
			return "redirect:/partner/tcbDog/dogList?repage";
		}
		if(StringUtils.isNotBlank(birthCerRegCode.getPedigreeCertified())){
			addMessage(redirectAttributes, "查询登记卡失败:该登记卡已有证书!");
			return "redirect:/partner/tcbDog/dogList?repage";
		}else if(StringUtils.isNotBlank(birthCerRegCode.getAddUser())){
			if(loginName.equals(birthCerRegCode.getAddUser())){
				addMessage(redirectAttributes, "查询登记卡失败:该登记卡已预约本机构!");
				return "redirect:/partner/tcbDog/dogList?birthCerRegCode="+birthCode;
			}else{
				addMessage(redirectAttributes, "查询登记卡失败:该登记卡已预约其他机构!");
				return "redirect:/partner/tcbDog/dogList?repage";
			}
		}
		model.addAttribute("birthcode", birthCode);
		if(StringUtils.isNotBlank(birthCerRegCode.getIdentificationFlag())){// 新出生纸申请
			return "partner/tcbDog/dogChipNewForm";
		}
		return "partner/tcbDog/dogChipForm";
	}
	
	
	/**
	 * 淘宠宝血统证书管理
	 * @Author chaixueteng
	 * @2017年11月1日上午10:58:21
	 */
	@RequestMapping(value="dogList")
	public String dogList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		Page<DogBirthCertificate> page = dogBirthCertificateService.findClubPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		return "partner/tcbDog/dogBirthCertificateList";
	}

	/**
	 * 根据出生纸和芯片号查询
	 * @Author chaixueteng(新出生)
	 * @2016年10月12日下午4:26:03
	 */
	@RequestMapping(value = "searchMessage")
	@ResponseBody
	public 	Object searchMessage(HttpServletRequest request, HttpServletResponse response){
		Map<String,String> map=new HashMap<String,String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String chipCode = request.getParameter("chipCode");
			map = clubMemberService.searchMessage(birthCode.trim(),chipCode.trim());
			 map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	

	/**
	 * 淘宠宝办理旧出生纸
	 * @Author chaixueteng
	 * @2017年11月1日下午2:42:03
	 */
	@RequestMapping(value = "oldDogAdd")
	public String oldDogAdd(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes){
		String identificationFlag = request.getParameter("xinpian2");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String memberCode = request.getParameter("memberCode");
		String dna = request.getParameter("dna");
		String parent = request.getParameter("parent");
		try {
			tcbDogService.add(birthCerRegCode,identificationFlag,memberCode,dna,parent);
		} catch (Exception e) {
			logger.warn("录入芯片失败",e);
			addMessage(redirectAttributes, "录入芯片失败:"+e.getMessage());
		}
		return "redirect:/partner/tcbDog/dogList?repage";
	}
	
	/**
	 * 淘宠宝办理旧出生纸
	 * @Author chaixueteng
	 * @2017年11月1日下午2:42:03
	 */
	@RequestMapping(value = "newDogAdd")
	public String newDogAdd(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes){
		String identificationFlag = request.getParameter("chipCode");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String memberCode = request.getParameter("memberCode");
		String dna = request.getParameter("dna");
		String parent = request.getParameter("parent");
		try {
			tcbDogService.newDogAdd(birthCerRegCode,identificationFlag,memberCode,dna,parent);
		} catch (Exception e) {
			logger.warn("录入芯片失败",e);
			addMessage(redirectAttributes, "录入芯片失败:"+e.getMessage());
		}
		return "redirect:/partner/tcbDog/dogList?repage";
	}
	

	
}
