package com.cku.partner.club.web;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DogVideoAppraisal;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.DogVideoAppraisalService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.dog.model.RestDogColorMark;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.service.DictService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping(value = "/partner/dogvideoappraisal")
public class PartnerDogVideoAppraisalController extends BaseController {

	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private OrgService orgService;

//	@RequiresPermissions("dogVideoAppraisal:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogVideoAppraisal dogVideoAppraisal, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		dogVideoAppraisal.setClubCode(org.getMemberCode());
		Page<DogVideoAppraisal> page = dogVideoAppraisalService.findPage(new Page<DogVideoAppraisal>(request, response),
				dogVideoAppraisal);

		List<DogVideoAppraisal> list = page.getList();
		for (DogVideoAppraisal videoAppraisal : list) {
			String runningNumber = videoAppraisal.getRunningNumber();
			if (StringUtils.isNotBlank(runningNumber)) {
				// 查询订单详情是否在退款中或审核通过 不可操作业务
				PaymentOrderDetail byOrderCode = paymentOrderDetailDao.getByOrderCode(runningNumber);
				if (byOrderCode != null && ("3".equals(byOrderCode.getBusinessRefundState())
						|| "1".equals(byOrderCode.getBusinessRefundState()))) {
					videoAppraisal.setBusinessRefundState(byOrderCode.getBusinessRefundState());
				}
			}
		}

		model.addAttribute("page", page);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("orgList", orgService.findAll());
		model.addAttribute("dogVideoAppraisal", dogVideoAppraisal);

		return "partner/club/dogVideoAppraisalList";
	}

//	@RequiresPermissions("dogVideoAppraisal:print")
	@RequestMapping(value = "print")
	public String print(DogVideoAppraisal dogVideoAppraisal, Model model, RedirectAttributes redirectAttributes) {

		try {
			return dogVideoAppraisalService.print(dogVideoAppraisal, model);
		} catch (ZAException e) {
			logger.warn("打印出错", e);
			addMessage(redirectAttributes, "打印出错:" + e.getMessage());
		}
//		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
		return "redirect:/partner/dogvideoappraisal/list?repage";
	}

}
