package com.cku.partner.club.web;

import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.OrgService;
import com.cku.partner.club.service.ClubDogActivitionService;
import com.cku.partner.club.service.PaymentService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping(value="/partner/dogActivation")
public class ClubDogActivationController extends BaseController{
	@Autowired
	private ClubDogActivitionService clubDogActivitionService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentService paymentService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private FileService fileService;
	@Autowired
	private DogChipDao dogChipDao;

	@RequestMapping(value = {"list", ""})
	public String list(DogActivation dogActivation, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		dogActivation.setOrgId(org.getId());
		Page<DogActivation> page = dogActivationService.findPage(new Page<DogActivation>(request, response), dogActivation);
		List<DogActivation> list = page.getList();
		for (DogActivation dogActivation2 : list) {
			if(StringUtils.isNotBlank(dogActivation2.getBirthCode())){
				String reviewState = dogActivation2.getReviewState();
				if(reviewState.equals("0")){
					reviewState = "激活中";
				}else if(reviewState.equals("1")){
					reviewState = "已激活";
				}else if(reviewState.equals("2")){
					reviewState = "激活失败";
				}
				dogActivation2.setReviewState(reviewState);
				DogChip dogChip = dogChipDao.getByBirthCode(dogActivation2.getBirthCode());
				if(dogChip != null && "1".equals(dogChip.getIsAll())){
					dogActivation2.setPaymentTime(dogChip.getProcessTime());
				}
			}
		}
		model.addAttribute("page", page);
		return "partner/dogActivation/dogActivationList";
	}

	@RequestMapping(value = "form")
	public String form() {
		return "partner/dogActivation/dogActivationForm";
	}

	@RequestMapping(value = "getDogMessage")
	@ResponseBody
	public 	Object getDogMessage(HttpServletRequest request, HttpServletResponse response){
		Map<String,String> map=new HashMap<String,String>();
		String birthCode = request.getParameter("birthCode");
		try {
			map = clubDogActivitionService.getDogMessage(birthCode);
			map.put("checkBirthCode",birthCode);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	@RequestMapping(value="layupload")
	@ResponseBody
    public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException
    {
		BaseFile baseFile = fileService.uploadFile(file,"ShowPic","1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/"+baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");//ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
    }

	@RequestMapping(value = "save")
	public String save(HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
		String birthCode = request.getParameter("birthCode");
		String frontPic = request.getParameter("frontPic");
		String sidePic = request.getParameter("sidePic");
		String backPic = request.getParameter("backPic");
		try {
			clubDogActivitionService.add(frontPic, sidePic, backPic, birthCode);
			addMessage(redirectAttributes, "激活犬只成功,请缴费");

		} catch (Exception e) {
			logger.warn("激活犬只失败",e);
			addMessage(redirectAttributes, "激活犬只失败:"+e.getMessage());
		}

		return "redirect:/partner/dogActivation/list?repage";
	}
	@RequestMapping(value = "toOrder")
	public String toOrder(String  id, RedirectAttributes redirectAttributes, Model model) {

		Org org = (Org) UserUtils.getSession().getAttribute("org");
			//重新查找  session域固定不变 所以需要重新查询 余额
		String orgId = org.getId();
		Org org2 = orgService.get(orgId);
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		try {
			DogActivation dogActivation = dogActivationService.get(id);
			list= clubDogActivitionService.toOrder(dogActivation);
		} catch (Exception e) {
			addMessage(redirectAttributes, "生成订单失败:"+e.getMessage());
			return "redirect:/partner/dogActivation/list?repage";
		}
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder byOrderCode = paymentOrderDao.getOrderByRunningNum(orderCode);
		model.addAttribute("orderId",byOrderCode.getId());
		model.addAttribute("paymentOrderDetail", list);
		model.addAttribute("org", org2);
		return "partner/dogActivation/activitionPaymentPage";
	}
	@RequestMapping(value="paymentOrder")
	public String paymentOrder(HttpServletRequest request,HttpServletResponse response){
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		if ("25".equals(paymentWay)) {//余额缴费
			String paymentOrder = paymentService.activitionPaymentOrder(paymentWay,orderId);
			return paymentOrder;
		}
		return "redirect:/partner/dogActivation/activitionPaymentPage";
	}
	@RequestMapping(value="delActivition")
	public String delActivition(RedirectAttributes redirectAttributes,HttpServletRequest request,HttpServletResponse response){
		String id = request.getParameter("id");
		try {
			DogActivation dogActivation = dogActivationService.get(id);
			dogActivationService.delete(dogActivation);
			addMessage(redirectAttributes, "删除犬只激活成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除犬只激活失败:"+e.getMessage());
		}
		return "redirect:/partner/dogActivation/list?repage";
	}
}