package com.cku.partner.club.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class ClubDogActivitionService {

	private static final String DOG_ACTIVATION_FEE = "dog_activation@all";
	private static final String DOG_ACTIVATION_NOTOUTTOME_FEE = "dog_activation@time";
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	public MemberDao memberDao;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;
	@Autowired
	public OrgDogTypeLimitService orgDogTypeLimitService;

	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> add(String frontPic, String sidePic, String backPic, String birthCerRegCode) {
		if (StringUtils.isBlank(frontPic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只正面照!");
		}
		if (StringUtils.isBlank(sidePic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只侧面照!");
		}
		if (StringUtils.isBlank(backPic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只背面照!");
		}
		DogBirthCertificate birthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode.trim());
		if (birthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询的登记卡编号有误!");
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), birthCertificate.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		DogActivation dogActivation = dogActivationService.getByBirthCode(birthCerRegCode.trim());
		DogActivation dogActivation2 = new DogActivation();
		if (dogActivation != null && "0".equals(dogActivation.getDelFlag())) {
			if (dogActivation.getReviewState().equals("1")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经激活!");
			} else if (dogActivation.getReviewState().equals("0")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经办理过激活申请，请直接缴费或等待审核!");
			} else if (dogActivation.getReviewState().equals("2")) {
				Calendar calendar = Calendar.getInstance();
				calendar.setTime(birthCertificate.getSendDate());
				calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY + 1);
				if (System.currentTimeMillis() > calendar.getTimeInMillis()) {
					dogActivation2 = buildDogActivation(frontPic, sidePic, backPic, birthCertificate);
					dogActivationService.delete(dogActivation);
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只业务状态不符合激活条件!");
				}
			}
		} else {
			if (birthCertificate.getCreateDate().getTime() < DogBirthCertificateService.DOG_ACTIVATION_MILLIS
					|| StringUtils.isNotBlank(birthCertificate.getActivitionState())
					|| birthCertificate.getSendDate() == null || !"1".equals(birthCertificate.getReviewState())
					|| birthCertificate.getSendDate() == null
					|| System.currentTimeMillis() < birthCertificate.getSendDate().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只业务状态不符合激活条件!");
			}
			dogActivation2 = buildDogActivation(frontPic, sidePic, backPic, birthCertificate);
		}
		List<PaymentOrderDetail> paymentOrderDetails = addToOrder(dogActivation2);
		dogActivation2.setRunningNumber(paymentOrderDetails.get(0).getOrderCode());
		dogActivationService.save(dogActivation2);
//		//更新出生纸表的激活状态
//		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(dogActivation2.getBirthCode());
//		dogBirthCertificate.setActivitionState("0");
//		dogBirthCertificateService.save(dogBirthCertificate);
		return paymentOrderDetails;
	}

	private PaymentOrder buildPaymentOrder(DogActivation dogActivation) {
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Member orgMember = org.getMember();
		Member member = memberService.getByMemberCode(dogActivation.getMemberCode());
		order.setMemberCode(member.getMemberCode());
		order.setMemberName(member.getName());
		order.setAddTime(new Date());
		order.setSource(orgMember.getLoginType());
		return order;
	}

	@Transactional(readOnly = false)
	private List<PaymentOrderDetail> buildPaymentOrderDetailList(PaymentOrder paymentOrder,
			DogActivation dogActivation) {

		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		if (dogActivation == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只激活记录有误!");
		} else {
			PaymentChargingItem paymentChargingItem = getDogActivationItem(dogActivation.getBirthCode());
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setAddTime(paymentOrder.getAddTime());
			detail.setProccessState("0");
			detail.setTotalPrice(paymentChargingItem.getPrice());
			detail.setNum("1");
			detail.setPrice(paymentChargingItem.getPrice());
			detail.setBusinessTable("dog_activation");
			detail.setChargingItemId(paymentChargingItem.getId());
			detail.setMemberCode(paymentOrder.getMemberCode());
			detail.setMemberName(paymentOrder.getMemberName());
			detail.setChargingItemName(paymentChargingItem.getName());
			detail.setBusinessIds(dogActivation.getId());
			paymentOrderDetailList.add(detail);
		}
		return paymentOrderDetailList;
	}

	private PaymentChargingItem getDogActivationItem(String birthCode) {
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dogBirthCertificate.getSendDate());
		calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY + 1);
		if (System.currentTimeMillis() > calendar.getTimeInMillis()) {
			return paymentChargingItemService.getByShortName(DOG_ACTIVATION_FEE);
		} else {
			return paymentChargingItemService.getByShortName(DOG_ACTIVATION_NOTOUTTOME_FEE);
		}
	}

	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> addToOrder(DogActivation dogActivation) {
		// 设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(dogActivation);
		// 构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder, dogActivation);
		// 计算订单总额
		Double orderTotal = 0d;
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			orderTotal = orderTotal + Double.parseDouble(detail.getTotalPrice());
		}
		// 保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		// 回写订单详情的OrderCode字段
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		// 保存订单详情
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		// 更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())
					&& !"sys_member".equals(paymentOrderDetail.getBusinessTable())
					&& !"kennel".equals(paymentOrderDetail.getBusinessTable())) {
				String businessIds = paymentOrderDetail.getBusinessIds();
				if (businessIds.contains(",")) {
					String[] bids = businessIds.split(",");
					for (int j = 0; j < bids.length; j++) {
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
								paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
							paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}

	public DogActivation buildDogActivation(String frontPic, String sidePic, String backPic,
			DogBirthCertificate birthCertificate) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		DogActivation dogActivation = new DogActivation();
		dogActivation.setOrgId(org.getId());
		dogActivation.setBackPic(backPic);
		dogActivation.setFrontPic(frontPic);
		dogActivation.setSidePic(sidePic);
		dogActivation.setBirthCode(birthCertificate.getBirthCerRegCode());
		dogActivation.setMemberCode(birthCertificate.getMemberCode());
		dogActivation.setState("0");
		dogActivation.setReviewRemarks("");
		dogActivation.setPaymentState("1");
		dogActivation.setLifePic("");
		dogActivation.setPrice("0");
		dogActivation.setReviewState("0");
		dogActivation.setRunningNumber("");
		dogActivation.setRemarks("");
		dogActivation.setReviewTime(new Date());
		dogActivation.setFrontPicRemark("");
		dogActivation.setSidePicRemark("");
		dogActivation.setBackPicRemark("");
		dogActivation.setFrontPicReviewState("0");
		dogActivation.setSidePicReviewState("0");
		dogActivation.setBackPicReviewState("0");
		dogActivation.setHealthInfo("{ \"immune\" :[], \"anthelmintic\" :[]}");
		dogActivation.setConsign("0");
		dogActivation.setType("1");
		dogActivation.setUpperReview("1");
		Member member = memberDao.getByMemberCode(birthCertificate.getMemberCode());
		dogActivation.setCity(member.getCity());
		dogActivation.setMobile(member.getSafeMobile() == null ? member.getMobile() : member.getSafeMobile());
		dogActivation.setLinkman(member.getName());
		dogActivationService.save(dogActivation);
		return dogActivation;
	}

	public List<PaymentOrderDetail> toOrder(DogActivation dogActivation) {
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		String runningNumber = dogActivation.getRunningNumber();
		PaymentOrder order = null;
		if (StringUtils.isNotBlank(runningNumber)) {
			order = paymentOrderDao.getOrderByRunningNum(runningNumber);
		}
		if (order == null) {// 订单不存在或者已经被删除了
			list = addToOrder(dogActivation);
		} else {
			list = paymentOrderDetailDao.getOrderByRunningNum(runningNumber, dogActivation.getMemberCode());
		}
		return list;
	}

	public Map<String, String> getDogMessage(String birthCode) {
		Map<String, String> map = new HashMap<String, String>();
		DogBirthCertificate birthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode.trim());
		if (birthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询的登记卡编号有误!");
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), birthCertificate.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		// 判断是否为单犬种俱乐部会员
//		if ("singleTypeClub".equals(org.getOrgType())
//				&& !(birthCertificate.getTempMemberCode().equals(org.getAdminCode()))) {
//			Member singleMember = memberService.singleMember(birthCertificate.getTempMemberCode(), org.getUser().getLoginName());
//			if(singleMember == null) {
//				throw new ZAException(ZAErrorCode.ZA_ERROR,"不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
//			}
//		}
		// 判断是否为单犬种俱乐部会员
		// 1.繁殖人是俱乐部成员或主理人
		// 2.新犬主是俱乐部成员或主理人
		if ("singleTypeClub".equals(org.getOrgType())) {
			// 繁育人
			Member breederMember = memberService.singleMember(birthCertificate.getBreederMemberCode(),
					org.getUser().getLoginName());
			// 新犬主
			Member singleMember = memberService.singleMember(birthCertificate.getTempMemberCode(),
					org.getUser().getLoginName());
			if (!(breederMember != null
					|| (StringUtils.isBlank(birthCertificate.getBreederMemberCode()) ? ""
							: birthCertificate.getBreederMemberCode()).equals(org.getAdminCode())
					|| singleMember != null || birthCertificate.getTempMemberCode().equals(org.getAdminCode()))) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
			}
		}
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);

		if (dogChip != null && "1".equals(dogChip.getIsAll())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只为整窝办理，请去血统证书业务办理!");
		}
		DogActivation dogActivation = dogActivationService.getByBirthCode(birthCode.trim());
		if (dogActivation != null && "0".equals(dogActivation.getDelFlag())) {
			if (dogActivation.getReviewState().equals("1")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经激活!");
			} else if (dogActivation.getReviewState().equals("0")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经办理过激活申请，请直接缴费或等待审核!");
			} else if (dogActivation.getReviewState().equals("2")) {
				Calendar calendar = Calendar.getInstance();
				calendar.setTime(birthCertificate.getSendDate());
				calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY + 1);
				if (System.currentTimeMillis() > calendar.getTimeInMillis()) {
					map.put("frontPic", dogActivation.getFrontPic());
					map.put("sidePic", dogActivation.getSidePic());
					map.put("backPic", dogActivation.getBackPic());
					map.put("frontPicReviewState", dogActivation.getFrontPicReviewState());
					map.put("sidePicReviewState", dogActivation.getSidePicReviewState());
					map.put("backPicReviewState", dogActivation.getBackPicReviewState());
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只业务状态不符合激活条件!");
				}
			}
		} else {
//			String businessState = dogBirthCertificateService.getBusinessState(birthCertificate);
			if (birthCertificate.getCreateDate().getTime() < DogBirthCertificateService.DOG_ACTIVATION_MILLIS
					|| StringUtils.isNotBlank(birthCertificate.getActivitionState())
					|| birthCertificate.getSendDate() == null || !"1".equals(birthCertificate.getReviewState())
					|| birthCertificate.getSendDate() == null
					|| System.currentTimeMillis() < birthCertificate.getSendDate().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只业务状态不符合激活条件!");
			}
		}
		DogType dogType = dogTypeService.getByDogBreedCode(birthCertificate.getDogBreed());
		map.put("dogBreedCnName", dogType == null ? "" : dogType.getBreedCnName());// 品种
		map.put("dogGender", DictUtils.getDictLabel(birthCertificate.getDogGender(), "dog_gender", ""));// 性别
		map.put("dogEnName", birthCertificate.getDogEnName());// 犬只姓名
		map.put("identificationFlag", birthCertificate.getIdentificationFlag());
		map.put("colorFlag",
				dogColorMarkService.getByDogColorMarkCode(birthCertificate.getColorFlag()).getDogColorMarkCn());
		map.put("dogBirthday", DateUtils.formatDate(birthCertificate.getDogBirthday()));
		map.put("sameBatchNum", birthCertificate.getSameBatchNum());
		map.put("dogOwenr", birthCertificate.getDogOwenr());
		map.put("rc", "0");
		return map;
	}
}