/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.statistics.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 年费拆分到月Entity
 * @author fanhuibin
 * @version 2017-02-21
 */
public class SaPaymentDetail extends DataEntity<SaPaymentDetail> {
	
	private static final long serialVersionUID = 1L;
	private String chargeItemId;		// 收费项id
	private Date chargeDate;		// 真正扣款的时间
	private String memberCode;		// 缴费的会员号
	private String paymentMoney;		// 付费的金额
	private String runningNumber;		// 流水号
	private String orderId;		//订单Id
	private String recordId;		// 流水Id
	private String price;
	private Date paymentTime;
	private String type; //收费项的分类，cab,cku,original
	private int paymentNum;
	private String deptId;
	private String startDate;
	private String endDate;
	private Date installmentBeginDate;
	private Date installmentEndDate;
	private String sourceCharge;
	
	public SaPaymentDetail() {
		super();
	}

	public SaPaymentDetail(String id){
		super(id);
	}

	public SaPaymentDetail(String deptId,String chargeItemId,String startDate,String endDate){
		this.deptId = deptId;
		this.chargeItemId = chargeItemId;
		this.startDate = startDate;
		this.endDate = endDate;
	}

	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min=1, max=32, message="收费项id长度必须介于 1 和 32 之间")
	public String getChargeItemId() {
		return chargeItemId;
	}

	public void setChargeItemId(String chargeItemId) {
		this.chargeItemId = chargeItemId;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="真正扣款的时间不能为空")
	public Date getChargeDate() {
		return chargeDate;
	}

	public void setChargeDate(Date chargeDate) {
		this.chargeDate = chargeDate;
	}
	
	@Length(min=1, max=200, message="缴费的会员号长度必须介于 1 和 200 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	public String getPaymentMoney() {
		return paymentMoney;
	}

	public void setPaymentMoney(String paymentMoney) {
		this.paymentMoney = paymentMoney;
	}
	
	@Length(min=1, max=32, message="流水号长度必须介于 1 和 32 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=1, max=32, message="订单号长度必须介于 1 和 32 之间")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public int getPaymentNum() {
		return paymentNum;
	}

	public void setPaymentNum(int paymentNum) {
		this.paymentNum = paymentNum;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public Date getInstallmentBeginDate() {
		return installmentBeginDate;
	}

	public void setInstallmentBeginDate(Date installmentBeginDate) {
		this.installmentBeginDate = installmentBeginDate;
	}

	public Date getInstallmentEndDate() {
		return installmentEndDate;
	}

	public void setInstallmentEndDate(Date installmentEndDate) {
		this.installmentEndDate = installmentEndDate;
	}

	public String getRecordId() {
		return recordId;
	}

	public void setRecordId(String recordId) {
		this.recordId = recordId;
	}

	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getSourceCharge() {
		return sourceCharge;
	}

	public void setSourceCharge(String sourceCharge) {
		this.sourceCharge = sourceCharge;
	}
}