/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 商品管理Entity
 * @author lyy
 * @version 2016-08-11
 */
public class ShopGoods extends DataEntity<ShopGoods> {
	
	private static final long serialVersionUID = 1L;
	private String classId;		// 商品分类主键
	@ExcelField(title="分类名称", align=2, sort=1)
	private String className;		//商品分类名称
	@ExcelField(title="商品编号", align=2, sort=2)
	private String code;		//商品编号
	@ExcelField(title="商品名称", align=2, sort=3)
	private String name;		// 商品名称
	private String image;		// 商品展示图
	private List<String> imageList = new ArrayList<String>();	 //商品展现图list
	@ExcelField(title="商品单价", align=2, sort=4)
	private String price;		// 商品单价
	@ExcelField(title="买赠", align=2, sort=4)
	private String buyGifts;		// 买赠
	@ExcelField(title="返利", align=2, sort=5)
	private String isRebate;		// 返利
	@ExcelField(title="运费", align=2, sort=6)
	private String isFreight;		// 运费
	@ExcelField(title="重量KG", align=2, sort=7)
	private String weight;		// 重量
	@ExcelField(title="标题", align=2, sort=8)
	private String title;		// 标题
	@ExcelField(title="标签", align=2, sort=9)
	private String tag;		// 标签
	private String details;		// 商品详细
	@ExcelField(title="上架", align=2, sort=10)
	private String isShelves;		// 上架
	@ExcelField(title="限购", align=2, sort=11)
	private String limits;		// 限购
	@ExcelField(title="数量", align=2, sort=12)
	private String num;		// 数量
	private String saleNum;		// 销售数量
	private String commentNum;		// 评论数量
	@ExcelField(title="添加时间", align=2, sort=13)
	private Date addTime;			//添加时间

	private String isInterval;		// 是否有分区
	private String interval1Num;		// 分区1数量
	private String interval1Price;  // 分区1价格
	private String interval2Num;		// 分区2数量
	private String interval2Price;  // 分区2价格
	private String interval3Price;  // 分区3价格

	public ShopGoods() {
		super();
	}
	public ShopGoods(String id,String name){
		this.id = id;
		this.name = name;
	}
	public ShopGoods(String id){
		super(id);
	}

	@Length(min=1, max=64, message="商品分类主键长度必须介于 1 和 64 之间")
	public String getClassId() {
		return classId;
	}

	public void setClassId(String classId) {
		this.classId = classId;
	}
	
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Length(min=0, max=100, message="商品名称长度必须介于 0 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min=0, max=255, message="商品展示图个数介于 0 和 7 之间")
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		if(!StringUtils.isEmpty(image)){
			if(StringUtils.contains(image,",")){
				imageList = Arrays.asList(image.split(","));
			}else{
				imageList.add(image);
			}
		}
		this.image = image;
	}
	
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}
	
	@Length(min=0, max=2, message="买赠长度必须介于 0 和 2 之间")
	public String getBuyGifts() {
		return buyGifts;
	}

	public void setBuyGifts(String buyGifts) {
		this.buyGifts = buyGifts;
	}
	
	@Length(min=0, max=1, message="返利长度必须介于 0 和 1 之间")
	public String getIsRebate() {
		return isRebate;
	}

	public void setIsRebate(String isRebate) {
		this.isRebate = isRebate;
	}
	
	@Length(min=0, max=1, message="运费长度必须介于 0 和 1 之间")
	public String getIsFreight() {
		return isFreight;
	}

	public void setIsFreight(String isFreight) {
		this.isFreight = isFreight;
	}
	
	@Length(min=0, max=50, message="重量长度必须介于 0 和 50 之间")
	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}
	
	@Length(min=0, max=200, message="标题长度必须介于 0 和 200 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@Length(min=0, max=100, message="标签长度必须介于 0 和 100 之间")
	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}
	
	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}
	
	@Length(min=0, max=1, message="上架长度必须介于 0 和 1 之间")
	public String getIsShelves() {
		return isShelves;
	}

	public void setIsShelves(String isShelves) {
		this.isShelves = isShelves;
	}
	
	@Length(min=0, max=11, message="限购长度必须介于 0 和 11 之间")
	public String getLimits() {
		return limits;
	}

	public void setLimits(String limits) {
		this.limits = limits;
	}
	
	@Length(min=0, max=11, message="数量长度必须介于 0 和 11 之间")
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}
	
	@Length(min=0, max=11, message="销售数量长度必须介于 0 和 11 之间")
	public String getSaleNum() {
		return saleNum;
	}

	public void setSaleNum(String saleNum) {
		this.saleNum = saleNum;
	}
	
	@Length(min=0, max=11, message="评论数量长度必须介于 0 和 11 之间")
	public String getCommentNum() {
		return commentNum;
	}

	public void setCommentNum(String commentNum) {
		this.commentNum = commentNum;
	}

	public String getIsInterval() {
		return isInterval;
	}

	public void setIsInterval(String isInterval) {
		this.isInterval = isInterval;
	}

	public String getInterval1Num() {
		return interval1Num;
	}

	public void setInterval1Num(String interval1Num) {
		this.interval1Num = interval1Num;
	}

	public String getInterval1Price() {
		return interval1Price;
	}

	public void setInterval1Price(String interval1Price) {
		this.interval1Price = interval1Price;
	}

	public String getInterval2Num() {
		return interval2Num;
	}

	public void setInterval2Num(String interval2Num) {
		this.interval2Num = interval2Num;
	}

	public String getInterval2Price() {
		return interval2Price;
	}

	public void setInterval2Price(String interval2Price) {
		this.interval2Price = interval2Price;
	}


	public String getInterval3Price() {
		return interval3Price;
	}

	public void setInterval3Price(String interval3Price) {
		this.interval3Price = interval3Price;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public List<String> getImageList() {
		return imageList;
	}
	public void setImageList(List<String> imageList) {
		this.imageList = imageList;
	}
}