package com.cku.oa.handler.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.handler.entity.RefereeRanking;
import com.cku.oa.handler.service.RefereeRankingSchemService;
import com.cku.oa.handler.service.RefereeRankingService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 牵犬师积分Controller
 * 
 * @author zxy
 * @version 2023-06-06
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/refereeRanking")
public class RefereeRankingController extends BaseController {
	@Autowired
	private RefereeRankingService refereeRankingService;
	@Autowired
	private RefereeRankingSchemService refereeRankingSchemService;

	@ModelAttribute
	public RefereeRanking get(@RequestParam(required = false) String id) {
		RefereeRanking entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = refereeRankingService.get(id);
		}
		if (entity == null) {
			entity = new RefereeRanking();
		}
		return entity;
	}

	@RequiresPermissions("handler:refereeRanking:view")
	@RequestMapping(value = { "list", "" })
	public String list(RefereeRanking refereeRanking, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<RefereeRanking> page = refereeRankingService.findPage(new Page<RefereeRanking>(request, response),
				refereeRanking);
		List<String> yearList = refereeRankingSchemService.getAllYear();
		List<String> monthList = refereeRankingSchemService.getAllMonth();
		model.addAttribute("yearList", yearList);
		model.addAttribute("monthList", monthList);
		model.addAttribute("page", page);
		return "oa/handler/refereeRankingList";
	}
	
	
	@RequiresPermissions("handler:refereeRanking:view")
    @RequestMapping(value = "export")
    public String export(RefereeRanking refereeRanking,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			refereeRankingService.export(refereeRanking,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出数据失败！失败信息："+e.getMessage());
		}
		return null;
    }

	
	@RequiresPermissions("handler:refereeRanking:view")
    @RequestMapping(value = "exportInfo")
    public void exportInfo(RefereeRanking refereeRanking,HttpServletResponse response, RedirectAttributes redirectAttributes) throws IOException {
		refereeRankingService.exportInfo(refereeRanking,response);
    }
}
