/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import org.hibernate.validator.constraints.Length;
import org.springframework.web.multipart.MultipartFile;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 牵犬师积分榜Entity
 * @author xx
 * @version 2022-06-06
 */
public class HandlerScoreRanking extends DataEntity<HandlerScoreRanking> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title = "会员号", align = 2, sort = 2)
	private String memberCode;		// 会员号
	@ExcelField(title = "姓名", align = 2, sort = 3)
	private String name;		// 会员姓名
	private String tableType;		// 榜单类型：M月榜 Q季度榜 Y年榜
	private Integer year;		// year
	private Integer month;		// month
	private Integer quarter;		// quarter
	@ExcelField(title = "名次", align = 2, sort = 1)
	private Integer ranking;		// 排名
	@ExcelField(title = "积分", align = 2, sort = 4)
	private Double score;		// 积分
	private MultipartFile fj;
	
	private String photo;		// 照片
	private String introduce;		// 简介
	
	private String gender;	
	
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public MultipartFile getFj() {
		return fj;
	}

	public void setFj(MultipartFile fj) {
		this.fj = fj;
	}

	public HandlerScoreRanking() {
		super();
	}

	public HandlerScoreRanking(String id){
		super(id);
	}

	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=64, message="会员姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	
	@Length(min=0, max=10, message="榜单类型：M月榜 Q季度榜 Y年榜长度必须介于 0 和 10 之间")
	public String getTableType() {
		return tableType;
	}

	public void setTableType(String tableType) {
		this.tableType = tableType;
	}
	
	@Length(min=1, max=4, message="year长度必须介于 1 和 4 之间")
	public Integer getYear() {
		return year;
	}

	public void setYear(Integer year) {
		this.year = year;
	}
	
	@Length(min=0, max=2, message="month长度必须介于 0 和 2 之间")
	public Integer getMonth() {
		return month;
	}

	public void setMonth(Integer month) {
		this.month = month;
	}
	
	@Length(min=0, max=1, message="quarter长度必须介于 0 和 1 之间")
	public Integer getQuarter() {
		return quarter;
	}

	public void setQuarter(Integer quarter) {
		this.quarter = quarter;
	}
	
	@Length(min=0, max=3, message="排名长度必须介于 0 和 3 之间")
	public Integer getRanking() {
		return ranking;
	}

	public void setRanking(Integer ranking) {
		this.ranking = ranking;
	}
	
	public Double getScore() {
		return score;
	}

	public void setScore(Double score) {
		this.score = score;
	}
	
}