package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cku.core.QueryByIdRequest;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.enums.GradeWrittenEnum;
import com.cku.oa.groomer.request.CommitWrittenExamDetailRequest;
import com.cku.oa.groomer.request.CommitWrittenExamRequest;
import com.cku.oa.groomer.service.*;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import org.apache.commons.collections.MapUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 美容资格认证笔试信息表Controller
 * @author hjx
 * @version 2023-11-23
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerWrittenExamInfo")
public class GroomerWrittenExamInfoController extends BaseController {

	@Autowired
	private GroomerWrittenExamInfoService groomerWrittenExamInfoService;

	@Autowired
	private GroomerExamQuestionsService groomerExamQuestionsService;

	@Autowired
	private GroomerExamQuestionsOptionsService groomerExamQuestionsOptionsService;

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@Autowired
	private GroomerShowService groomerShowService;
	
	@ModelAttribute
	public GroomerWrittenExamInfo get(@RequestParam(required=false) String id) {
		GroomerWrittenExamInfo entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerWrittenExamInfoService.get(id);
			logger.info("GroomerWrittenExamInfoController.get result : {}", JSONObjectUtils.toJsonString(entity));
		}
		if (entity == null){
			entity = new GroomerWrittenExamInfo();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerWrittenExamInfo:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerWrittenExamInfo groomerWrittenExamInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerWrittenExamInfo> page = groomerWrittenExamInfoService.findPage(new Page<GroomerWrittenExamInfo>(request, response), groomerWrittenExamInfo); 
		model.addAttribute("page", page);
		return "oa/groomer/groomerWrittenExamInfoList";
	}

	@RequiresPermissions("groomer:groomerWrittenExamInfo:view")
	@RequestMapping(value = "form")
	public String form(GroomerWrittenExamInfo groomerWrittenExamInfo, Model model) {
		model.addAttribute("groomerWrittenExamInfo", groomerWrittenExamInfo);
		return "oa/groomer/groomerWrittenExamInfoForm";
	}

	@RequiresPermissions("groomer:groomerWrittenExamInfo:edit")
	@RequestMapping(value = "save")
	public String save(GroomerWrittenExamInfo groomerWrittenExamInfo, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerWrittenExamInfo)){
			return form(groomerWrittenExamInfo, model);
		}
		groomerWrittenExamInfoService.save(groomerWrittenExamInfo);
		addMessage(redirectAttributes, "保存美容资格认证笔试信息表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerWrittenExamInfo/?repage";
	}
	
	@RequiresPermissions("groomer:groomerWrittenExamInfo:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerWrittenExamInfo groomerWrittenExamInfo, RedirectAttributes redirectAttributes) {
		groomerWrittenExamInfoService.delete(groomerWrittenExamInfo);
		addMessage(redirectAttributes, "删除美容资格认证笔试信息表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerWrittenExamInfo/?repage";
	}

	/**
	 * 成绩查看
	 */
	@RequiresPermissions("groomer:groomerRegister:view")
	@GetMapping(value = "/gradeDetail")
	public String gradeDetail(GroomerRegister groomerRegister, Model model){
		if (Objects.isNull(groomerRegister) || org.apache.commons.lang.StringUtils.isBlank(groomerRegister.getId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "必传参数为null");
		}
		GroomerRegister groomerRegisterResult = groomerRegisterService.get(groomerRegister.getId());
		Objects.requireNonNull(groomerRegisterResult);
		GroomerShow showCode = groomerShowService.getShowCode(groomerRegisterResult.getShowCode());
		Objects.requireNonNull(showCode);
		GroomerRegisterVO groomerRegisterVO = groomerRegisterService.queryGradeDetails(groomerRegisterResult);
		groomerRegisterVO.setGroomerShow(showCode);
		groomerRegisterVO.setShowCategory(showCode.getShowCategory());
		model.addAttribute("groomerRegisterVO", groomerRegisterVO);
		return "oa/groomer/groomerWrittenExamInfoList";
	}

	@RequiresPermissions("groomer:groomerRegister:view")
	@GetMapping("/gradeWriteDetail")
	public String gradeWriteDetail(GroomerWrittenExamInfo groomerWrittenExamInfo, Model model){
		logger.info("GroomerWrittenExamInfoController.gradeWriteDetail param : {}", JSONObjectUtils.toJsonString(groomerWrittenExamInfo));
		//获取该会员试卷信息
		String currentExamPaper = groomerWrittenExamInfo.getCurrentExamPaper();
		//获取该会员答题信息
		String answerInfo = groomerWrittenExamInfo.getAnswerInfo();

		CommitWrittenExamRequest commitWrittenExamRequest = JSON.parseObject(answerInfo, CommitWrittenExamRequest.class);
		Map<String, CommitWrittenExamDetailRequest> examDetailRequestMap = new HashMap<>();
		if (Objects.nonNull(commitWrittenExamRequest)) {
			examDetailRequestMap = commitWrittenExamRequest.getCommitWrittenExamDetailRequests().stream()
					.collect(Collectors.toMap(CommitWrittenExamDetailRequest::getQuestionId, Function.identity()));
		}
		logger.info("答题信息转为json格式为 examDetailRequestMap : {}", JSONObjectUtils.toJsonString(examDetailRequestMap));
		//用于jsp页面展示
		List<GroomerExamQuestions> groomerExamQuestionsList = new ArrayList<>();
		//该考生当时的考卷，考题和选项为随机，因此记录试卷信息
		JSONObject jsonObject = JSON.parseObject(currentExamPaper, JSONObject.class);
		for (Map.Entry<String, Object> stringObjectEntry : jsonObject.entrySet()) {
			String value = (String) stringObjectEntry.getValue();
			List<ExamPaperInfo> examPaperInfos = JSONArray.parseArray(value, ExamPaperInfo.class);
			List<String> questionIds = examPaperInfos.stream().map(ExamPaperInfo::getQuestionId).collect(Collectors.toList());
			//根据试卷id查询试卷信息
			List<GroomerExamQuestions> byExamPaperIdForDb = groomerExamQuestionsService.getByExamPaperIdAndNoDelFlag(stringObjectEntry.getKey());
			//根据问题ids查询问题信息
			List<GroomerExamQuestionsOptions> groomerExamQuestionsOptionsForDb = groomerExamQuestionsOptionsService
					.queryQuestionsOptionsByQuestionIdsAndNoDelFlag(questionIds);
			//将试卷信息转成map key为getQuestionId value为本身
			Map<String, GroomerExamQuestions> examQuestionsMap = byExamPaperIdForDb.stream()
					.collect(Collectors.toMap(GroomerExamQuestions::getQuestionId, Function.identity()));
			//将试题信息转成map key为getOptionId value为本身
			Map<String, GroomerExamQuestionsOptions> questionsOptionsMap = groomerExamQuestionsOptionsForDb.stream()
					.collect(Collectors.toMap(GroomerExamQuestionsOptions::getOptionId, Function.identity()));
			for (ExamPaperInfo examPaperInfo : examPaperInfos) {
				String questionId = examPaperInfo.getQuestionId();
				GroomerExamQuestions groomerExamQuestions = examQuestionsMap.get(questionId);
				//拿到考试该questionId的选项
				List<String> optionIds = examPaperInfo.getOptionIds();
				List<GroomerExamQuestionsOptions> groomerExamQuestionsOptionsList = new ArrayList<>();
				for (String optionId : optionIds) {
					GroomerExamQuestionsOptions groomerExamQuestionsOption = questionsOptionsMap.get(optionId);
					groomerExamQuestionsOptionsList.add(groomerExamQuestionsOption);
				}
				if (MapUtils.isNotEmpty(examDetailRequestMap) && Objects.nonNull(examDetailRequestMap.get(questionId))) {
					groomerExamQuestions.setSelectOptionId(examDetailRequestMap.get(questionId).getSelectOptionId());
					groomerExamQuestions.setGroomerExamQuestionsOptionsList(groomerExamQuestionsOptionsList);
					groomerExamQuestionsList.add(groomerExamQuestions);
				}

			}
		}
		model.addAttribute("groomerExamQuestionsList", groomerExamQuestionsList);
		return "oa/groomer/groomerWrittenExamInfoForm";
	}

	/**
	 * 美容考试活动重置
	 */
	@RequiresPermissions("groomer:groomerRegister:edit")
	@RequestMapping("/reset")
	public String reset(@Valid QueryByIdRequest idRequest , HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {

		// 查询会员
		GroomerWrittenExamInfo groomerWrittenExamInfo = groomerWrittenExamInfoService.get(idRequest.getId());
		if (Objects.isNull(groomerWrittenExamInfo)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "笔试信息无法重置，该条记录找不到！");
		}
		GroomerRegister groomerRegister = groomerRegisterService.get(groomerWrittenExamInfo.getRegisterId());
		if (Objects.equals(groomerRegister.getGradeWrite(), GradeWrittenEnum.PASSED.code())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "理论考试通过无法修改");
		}
		groomerRegisterService.resetExam(groomerRegister ,groomerWrittenExamInfo);
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerWrittenExamInfo/gradeDetail?id=" + groomerRegister.getId();
	}
}