/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import java.sql.Timestamp;
import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 订单详细Entity
 * 
 * @author lyy
 * @version 2016-08-04
 */
public class PaymentOrderDetail extends DataEntity<PaymentOrderDetail> {

	private static final long serialVersionUID = 1L;

	private String orderCode; // 订单号
	private String memberCode; // 会员号
	private String memberName; // 会员名称
	private String chargingItemId; // 收费项目
	private String chargingItemName; // 收费项目名称
	private String chargingItemCount; // 收费项目总数
	private String chargingItemPrice; // 收费项目总钱
	private String num; // 数量
	private String price; // 单价
	private String totalPrice; // 总价
	private Date addTime; // 添加时间
	private String projectId; // 项目主键
	private String projectName; // 订单项目名称
	private String voucherCode; // 凭证号
	private String proccessState; // 处理标示
	private Date proccessTime; // 处理时间
	private PaymentOrder paymentOrder; //
	private PaymentChargingItem paymentChargingItem; // 收费项目model

	private String businessCode;// 业务编码
	private String businessIds;// 业务的id
	private String businessTable; // 业务表名
	private String showBusinessModelFlag = "0";// 赛事业务模式

	private Date splitBeginDate;

	private Date startDate; // 拆分数据使用
	private Date endDate; // 拆分数据使用

	private String businessOrderCode; // 小业务号
	private String businessId;// 业务序号
	private String businessName;// 业务名字
	private String businessRefund;// 业务退款 0不支持,1支持
	private Timestamp businessRefundTime;// 业务退款时间
	private String businessRefundState;// '业务退款状态 1退款待审核，2审核不通过，3审核通过';
	private String businessRefundReason;// 退款原因

	public String getBusinessRefundReason() {
		return businessRefundReason;
	}

	public void setBusinessRefundReason(String businessRefundReason) {
		this.businessRefundReason = businessRefundReason;
	}

	public String getBusinessOrderCode() {
		return businessOrderCode;
	}

	public void setBusinessOrderCode(String businessOrderCode) {
		this.businessOrderCode = businessOrderCode;
	}

	public String getBusinessRefundState() {
		return businessRefundState;
	}

	public Timestamp getBusinessRefundTime() {
		return businessRefundTime;
	}

	public void setBusinessRefundTime(Timestamp businessRefundTime) {
		this.businessRefundTime = businessRefundTime;
	}

	public void setBusinessRefundState(String businessRefundState) {
		this.businessRefundState = businessRefundState;
	}

	public String getBusinessRefund() {
		return businessRefund;
	}

	public void setBusinessRefund(String businessRefund) {
		this.businessRefund = businessRefund;
	}

	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public PaymentOrderDetail() {
		super();
	}

	public PaymentOrderDetail(String id) {
		super(id);
	}

	public PaymentOrderDetail(PaymentOrder paymentOrder) {
		this.paymentOrder = paymentOrder;
	}

	@Length(min = 0, max = 100, message = "订单号长度必须介于 0 和 100 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "收费项目长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	@Length(min = 0, max = 11, message = "数量长度必须介于 0 和 11 之间")
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public String getPrice() {
		return price;
	}

	public Double getPriceDouble() {
		return Double.parseDouble(price);
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	@Length(min = 0, max = 64, message = "项目主键长度必须介于 0 和 64 之间")
	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	@Length(min = 0, max = 100, message = "凭证号长度必须介于 0 和 100 之间")
	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	@Length(min = 0, max = 100, message = "处理标示长度必须介于 0 和 100 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	public PaymentOrder getPaymentOrder() {
		return paymentOrder;
	}

	public void setPaymentOrder(PaymentOrder paymentOrder) {
		this.paymentOrder = paymentOrder;
	}

	@Length(min = 0, max = 100, message = "标识名称长度必须介于 0 和 100 之间")
	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	@Length(min = 0, max = 100, message = "会员名称长度必须介于 0 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 100, message = "项目名称长度必须介于 0 和 100 之间")
	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}

	public String getChargingItemCount() {
		return chargingItemCount;
	}

	public void setChargingItemCount(String chargingItemCount) {
		this.chargingItemCount = chargingItemCount;
	}

	public String getChargingItemPrice() {
		return chargingItemPrice;
	}

	public void setChargingItemPrice(String chargingItemPrice) {
		this.chargingItemPrice = chargingItemPrice;
	}

	public boolean equalsme(PaymentOrderDetail obj) {
		return this.memberCode.equals(obj.getMemberCode()) && this.projectId.equals(obj.getProjectId())
				&& this.voucherCode.equals(obj.getVoucherCode());
	}

	public PaymentChargingItem getPaymentChargingItem() {
		return paymentChargingItem;
	}

	public void setPaymentChargingItem(PaymentChargingItem paymentChargingItem) {
		this.paymentChargingItem = paymentChargingItem;
	}

	public String getBusinessIds() {
		return businessIds;
	}

	public void setBusinessIds(String businessIds) {
		this.businessIds = businessIds;
	}

	public String getBusinessTable() {
		return businessTable;
	}

	public void setBusinessTable(String businessTable) {
		this.businessTable = businessTable;
	}

	public Date getSplitBeginDate() {
		return splitBeginDate;
	}

	public void setSplitBeginDate(Date splitBeginDate) {
		this.splitBeginDate = splitBeginDate;
	}

	public String getShowBusinessModelFlag() {
		return showBusinessModelFlag;
	}

	public void setShowBusinessModelFlag(String showBusinessModelFlag) {
		this.showBusinessModelFlag = showBusinessModelFlag;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getBusinessCode() {
		return businessCode;
	}

	public void setBusinessCode(String businessCode) {
		this.businessCode = businessCode;
	}
}