/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 订单详细DAO接口
 * 
 * @author lyy
 * @version 2016-08-04
 */
@MyBatisDao
public interface PaymentOrderDetailDao extends CrudDao<PaymentOrderDetail> {
	int updateProccessState(PaymentOrderDetail paymentOrderDetail);

	int updateBusinessInfo(PaymentOrderDetail paymentOrderDetail);

	// 美容 培训 校验在线申领的订单
	List<PaymentOrderDetail> getOrderByRunningNum(@Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode);

	List<PaymentOrderDetail> statistical(@Param("projectId") String projectId);

	// 美容 培训 校验在线申领的订单
	List<PaymentOrderDetail> validOrder(PaymentOrderDetail paymentOrderDetail);

	PaymentOrderDetail getByOrderCode(@Param("orderCode") String orderCode);

	List<PaymentOrderDetail> getByOrderCodes(@Param("orderCodes") List<String> orderCodes);

	List<PaymentOrderDetail> findByOrderCode(@Param("orderCode") String orderCode);

	List<PaymentOrderDetail> findByOrderCodes(@Param("orderCodes") List<String> orderCodes);

	/**
	 * 获取全部（包含已删除）
	 * 
	 * @param orderCode
	 * @return
	 */
	List<PaymentOrderDetail> findAllByOrderCode(@Param("orderCode") String orderCode);

	List<PaymentOrderDetail> findByOrderCodeAndItemId(@Param("orderCode") String orderCode,
			@Param("itemId") String itemId);

	List<PaymentOrderDetail> findByOrderCodeAndDetailIdAndItemId(@Param("orderCode") String orderCode,
			@Param("orderDetailId") String orderDetailId, @Param("itemId") String itemId);

	/**
	 * 通过收费项查询指定范围内的付款记录
	 * 
	 * @param chargeItemId
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	List<PaymentOrderDetail> findDetailByChargeItem(@Param("chargeItemId") String chargeItemId,
			@Param("startDate") String startDate, @Param("endDate") String endDate);

	HashMap findDetailByChargeItemCount(@Param("chargeItemId") String chargeItemId,
			@Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 * 查询需要拆分调整的数据合集
	 * 
	 * @param detail
	 * @return
	 */
	List<PaymentOrderDetail> findAdjustmentList(PaymentOrderDetail detail);

	Integer getUsedDetail(@Param("tableName") String tableName, @Param("orderCode") String orderCode);

	void updateBusinessRefundState(PaymentOrderDetail vo);

	List<PaymentOrderDetail> getByBusiness(PaymentOrderDetail vo);

	List<PaymentOrderDetail> getByBusinessCode(PaymentOrderDetail vo);

	void updateRefundStateByParam(PaymentOrderDetail vo);

	List<PaymentOrderDetail> getByBusinessIds(@Param("ids") Set<String> ids);

	List<PaymentOrderDetail> findUnpaidDetail(@Param("memberCode") String memberCode);

	void updateBusinessRefund(@Param("businessIds") String businessIds);

	PaymentOrderDetail findPartnerNewMemberOrder(@Param("memberCode") String memberCode,
			@Param("businessIds") String businessIds);

	List<PaymentChargingItem> findChargingItemsByOrderCode(@Param("orderCode") String orderCode);

	int findByMemberCardCount(@Param("memberCardType") String memberCardType);

	int findByMemberCardReviewCount(@Param("businessCodes") List<String> businessCodes);

	List<PaymentOrderDetail> validOrderNurse(@Param("memberCode") String memberCode,
			@Param("chargingItemId") String chargingItemId, @Param("levelEn") String levelEn);

	int memberCancelOrderDetail(@Param("memberCode") String memberCode);

	int memberCancelOrder(@Param("memberCode") String memberCode);

	int batchInsert(@Param("orderDetailList") List<PaymentOrderDetail> orderDetailList);

}