/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.vo.DogNewbornVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 配种证明Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Controller
@RequestMapping(value = "${adminPath}/dognewborn/dogNewborn")
public class DogNewbornController extends BaseController {

	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private MemberService memberService;

	@ModelAttribute
	public DogNewborn get(@RequestParam(required = false) String id) {
		DogNewborn entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogNewbornService.get(id);
		}
		if (entity == null) {
			entity = new DogNewborn();
		}
		return entity;
	}

	@RequiresPermissions("dognewborn:dogNewborn:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogNewborn dogNewborn, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogNewborn> page = dogNewbornService.findPage(new Page<DogNewborn>(request, response), dogNewborn);

		// 查询有没有退款或退款中 fmdog_breed_certified_code
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogNewborn> list = page.getList().stream().map(a -> {
			DogNewbornVO b = new DogNewbornVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);

		if ("230".equals(dogNewborn.getDogBreed())) {
			return "oa/dog/dognewborn/dogNewbornListTibetanMastiff";
		} else {
			return "oa/dog/dognewborn/dogNewbornList";
		}
	}

	@RequiresPermissions("dognewborn:dogNewborn:view")
	@RequestMapping(value = "form")
	public String form(DogNewborn dogNewborn, Model model) {
		model.addAttribute("dogNewborn", dogNewborn);
		return "oa/dog/dognewborn/dogNewbornForm";
	}

	@RequiresPermissions("dognewborn:dogNewborn:edit")
	@RequestMapping(value = "save")
	public String save(DogNewborn dogNewborn, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogNewborn)) {
			return form(dogNewborn, model);
		}
		String breed = "";
		try {
			// 配种证明犬只校验
			dogNewbornService.validateDog(dogNewborn, "cku");
			dogNewbornService.save(dogNewborn);
			addMessage(redirectAttributes, "保存配种证明成功");
			if ("230".equals(dogNewborn.getDogBreed())) {
				breed = "&dogBreed=230";
			}
		} catch (Exception e) {
			addMessage(redirectAttributes, "保存配种证明失败，错误信息为：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dognewborn/dogNewborn/?repage" + breed;
	}

	@RequiresPermissions("dognewborn:dogNewborn:delete")
	@RequestMapping(value = "delete")
	public String delete(DogNewborn dogNewborn, RedirectAttributes redirectAttributes) {
		dogNewbornService.delete(dogNewborn);
		addMessage(redirectAttributes, "删除配种证明成功");
		String breed = "";
		if ("230".equals(dogNewborn.getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dognewborn/dogNewborn/?repage" + breed;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	/**
	 * 
	 * @Description：配种证明订单列表页
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午5:19:35
	 */
	@RequiresPermissions("dognewborn:dogNewborn:view")
	@RequestMapping(value = { "orderList" })
	public String orderList(DogNewborn dogNewborn, HttpServletResponse response, Model model) {
		List<DogNewborn> list = dogNewbornService.findList(dogNewborn);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogNewbornVO> list2 = list.stream().map(a -> {
			DogNewbornVO b = new DogNewbornVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/dognewborn/dogNewbornOrderList";
	}

	/**
	 * 
	 * @Description：配种证明业务添加页
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午5:21:39
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(DogNewborn dogNewborn, Model model, @RequestParam(required = true) String chargingItemId,
			@RequestParam(required = true) String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		model.addAttribute("dogNewborn", dogNewborn);
		model.addAttribute("chargingItemId", chargingItemId);
		model.addAttribute("memberCode", memberCode);
		return "oa/dog/dognewborn/dogNewbornOrderAdd";
	}

	/**
	 * 
	 * @Description：配种证明业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午5:22:45
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public String orderSave(DogNewborn dogNewborn, Model model, HttpServletRequest request) {
		try {
			dogNewbornService.orderSave(dogNewborn);
		} catch (Exception e) {
			return "保存订单失败:" + e.getMessage();
		}
		return "ok";
	}

	/**
	 * 
	 * @Description：配种证明业务删除
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午5:27:52
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderDelete")
	public String orderDelete(DogNewborn dogNewborn, RedirectAttributes redirectAttributes) {
		String runningNumber = dogNewborn.getRunningNumber();
		dogNewbornService.delete(dogNewborn);
		addMessage(redirectAttributes, "删除配种证明成功");
		return "redirect:" + Global.getAdminPath() + "/dognewborn/dogNewborn/orderList?runningNumber=" + runningNumber
				+ "&repage";
	}

	/**
	 * 
	 * @Description：修改配种证明信息
	 * @author: zhuoHeng
	 * @version: 2016年8月11日 下午2:43:16
	 */
	@RequiresPermissions("dognewborn:dogNewborn:edit")
	@RequestMapping(value = "edit")
	public String edit(DogNewborn dogNewborn, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogNewborn)) {
			return form(dogNewborn, model);
		}
		try {
			// 配种证明犬只校验
			dogNewbornService.validateDog(dogNewborn, "cku");
			dogNewbornService.edit(dogNewborn);
			addMessage(redirectAttributes, "保存配种证明成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "保存配种证明失败，错误信息为：" + e.getMessage());
		}
		String breed = "";
		if ("230".equals(dogNewborn.getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dognewborn/dogNewborn/?repage" + breed;
	}

	/**
	 * 
	 * @Description：跳转至配种证明申请审核页面
	 * @author: zhuoHeng
	 * @version: 2016年8月15日 下午6:11:44
	 */
	@RequiresPermissions("dognewborn:dogNewborn:audit")
	@RequestMapping(value = "dogNewbornReview")
	public String toReviewPage(DogNewborn dogNewborn, Model model) {
		model.addAttribute("dogNewborn", dogNewborn);
		return "oa/dog/dognewborn/dogNewbornReview";
	}

	/**
	 * 
	 * @Description：审核配种证明申请
	 * @author: zhuoHeng
	 * @version: 2016年8月15日 下午5:59:03
	 */
	@RequiresPermissions("dognewborn:dogNewborn:audit")
	@RequestMapping(value = "changeStatus")
	@ResponseBody
	public String changeStatus(DogNewborn dogNewborn, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogNewborn)) {
			return form(dogNewborn, model);
		}
		try {
			dogNewbornService.changeStatus(dogNewborn);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	/**
	 * 
	 * @Description：进入配种证明查看页
	 * @author: zhuoHeng
	 * @version: 2016年8月27日 下午3:14:00
	 */
	@RequiresPermissions("dognewborn:dogNewborn:view")
	@RequestMapping(value = "view")
	public String view(DogNewborn dogNewborn, Model model) {
		model.addAttribute("dogNewborn", dogNewborn);
		return "oa/dog/dognewborn/dogNewbornView";
	}

	/**
	 * 
	 * @Description：根据母犬血统证书号查询繁殖次数
	 * @author: zhuoHeng
	 * @version: 2016年9月1日 下午4:11:56
	 */
	@RequestMapping("getBreedNumber")
	@ResponseBody
	public String getBreedNumber(HttpServletRequest request) {
		String femalePedigreeCertified = request.getParameter("femalePedigreeCertified");
		return dogNewbornService.getBreedNumber(femalePedigreeCertified);
	}

	/**
	 * 
	 * @Description：根据母犬血统证书号查询父母犬只姓名和证书号
	 * @author: chaixueteng
	 * @version: 2016年9月1日 下午4:11:56
	 */
	@RequestMapping("getFM")
	@ResponseBody
	public Object getFM(HttpServletRequest request) {
		String breedCertifiedCode = request.getParameter("breedCertifiedCode");
		return dogNewbornService.getFM(breedCertifiedCode);
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByPedigreeCertified")
	@ResponseBody
	public Object getDogByPedigreeCertified(@RequestParam(required = true) String pedigreeCertified) {
		HashMap<String, String> map = dogNewbornService.getDogByPedigreeCertified(pedigreeCertified);
		return map;
	}
}