package com.cku.oa.dog.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import javax.annotation.PostConstruct;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogNoseDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.dogNoseprin.service.DogNoseRaffleService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只鼻纹Service
 *
 * @author xx
 * @version 2020-04-23
 */
@Service
@Transactional(readOnly = true)
public class DogNoseService extends CrudService<DogNoseDao, DogNose> {
	@Autowired
	private DogNoseRaffleService dogNoseRaffleService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private UserDao userDao;
	@Autowired
	private MemberDao memberDao;
//	@Autowired
//	private MemberService memberService;

	public DogNose get(String id) {
		return super.get(id);
	}

	public List<DogNose> findList(DogNose dogNose) {
		return super.findList(dogNose);
	}

	public Page<DogNose> findPage(Page<DogNose> page, DogNose dogNose) {
		return super.findPage(page, dogNose);
	}

	public Page<DogNose> findListApp(Page<DogNose> page, DogNose dogNose) {
		return super.findListApp(page, dogNose);
	}

	@Transactional(readOnly = false)
	public void save(DogNose dogNose) {
		super.save(dogNose);
	}

	@Transactional(readOnly = false)
	public void delete(DogNose dogNose) {
		super.delete(dogNose);
	}

	/**
	 * 保存nose_id，保存成功返回主键ID 重复的话返回空，不操作数据库
	 *
	 * @param noseId
	 * @param dogBirthCertificateId
	 * @param dogId
	 * @return
	 */
	@Transactional(readOnly = false)
	public String saveNoseId(String noseId, String dogBirthCertificateId, String dogId) {
		if (StringUtils.isBlank(noseId))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第三方鼻纹标识不能为空！");
		if (StringUtils.isBlank(dogBirthCertificateId) && StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "等级卡ID和犬只表ID不能同时为空！");
		}
		// 补充登记卡ID
		if (StringUtils.isBlank(dogBirthCertificateId)) {
			Dog dog = dogDao.get(dogId);
			if (dog == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
						.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (dogBirthCertificate != null)
					dogBirthCertificateId = dogBirthCertificate.getId();
			}
		}
		// 补充犬只ID
		if (StringUtils.isBlank(dogId)) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(dogBirthCertificateId);
			if (dogBirthCertificate == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dogBirthCertificate.getPedigreeCertified())) {
				Dog dog = dogDao.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
				if (dog != null)
					dogId = dog.getId();
			}
		}
		DogNose dogNose = dao.getByDogIdODogBirthCertificateId(dogBirthCertificateId, dogId);
		DogNose dogNoseC = dao.getByNoseId(noseId);
		if (dogNose == null) {
			// 新增
			if (dogNoseC != null) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			dogNose = new DogNose();
			dogNose.setNoseId(noseId);
			dogNose.setDogBirthCertificateId(dogBirthCertificateId);
			dogNose.setDogId(dogId);
			dogNose.setNoseCode(getNextNoseCode());
			dogNose.preInsert();
			dao.insert(dogNose);

			// 新增一个犬只鼻纹就增加一次抽奖机会，
			dogNoseRaffleService.addDogNoseprin(null);
		} else {
			// 修改
			if (dogNoseC != null && dogNose.getId() != dogNoseC.getId()) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			if (!dogNose.getNoseId().equals(noseId)) {// 如果相等无需修改
				dogNose.setNoseId(noseId);
				dogNose.setNoseCode(getNextNoseCode());// 下期做到修改，问下需求，显示鼻纹ID 换不换
				dogNose.preUpdate();
				dao.update(dogNose);
			}
		}
		return dogNose.getId();
	}

	@Transactional(readOnly = false)
	public String saveNoseIdByAdmin(String noseId, String dogBirthCertificateId, String dogId) {
		if (StringUtils.isBlank(noseId))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第三方鼻纹标识不能为空！");
		if (StringUtils.isBlank(dogBirthCertificateId) && StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "等级卡ID和犬只表ID不能同时为空！");
		}
		// 补充登记卡ID
		if (StringUtils.isBlank(dogBirthCertificateId)) {
			Dog dog = dogDao.get(dogId);
			if (dog == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
						.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (dogBirthCertificate != null)
					dogBirthCertificateId = dogBirthCertificate.getId();
			}
		}
		// 补充犬只ID
		if (StringUtils.isBlank(dogId)) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(dogBirthCertificateId);
			if (dogBirthCertificate == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dogBirthCertificate.getPedigreeCertified())) {
				Dog dog = dogDao.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
				if (dog != null)
					dogId = dog.getId();
			}
		}
		DogNose dogNose = dao.getByDogIdODogBirthCertificateId(dogBirthCertificateId, dogId);
		DogNose dogNoseC = dao.getByNoseId(noseId);
		if (dogNose == null) {
			// 新增
			if (dogNoseC != null) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			dogNose = new DogNose();
			dogNose.setNoseId(noseId);
			dogNose.setDogBirthCertificateId(dogBirthCertificateId);
			dogNose.setDogId(dogId);
			dogNose.setNoseCode(getNextNoseCode());
			// concat(date_format(now(), '%Y%m%d'),LPAD(max(RIGHT(nose_code, 7))+1, 7, 0))
			dogNose.preInsert();
			dao.insert(dogNose);
		} else {
			// 修改
			if (dogNoseC != null && dogNose.getId() != dogNoseC.getId()) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			if (!dogNose.getNoseId().equals(noseId)) {// 如果相等无需修改
				dogNose.setNoseId(noseId);
				dogNose.setNoseCode(getNextNoseCode());// 下期做到修改，问下需求，显示鼻纹ID 换不换
				dogNose.preUpdate();
				dao.update(dogNose);
			}
		}
		return dogNose.getId();
	}

	/**
	 * @Description: 保存nose_id，保存成功返回主键ID 重复的话返回空，不操作数据库(合作机构使用取用户信息和会员不一样)
	 * @author: zhangxiang
	 * @date: 2020/7/23 14:44
	 */
	@Transactional(readOnly = false)
	public String saveNoseIdTOOrg(String noseId, String dogBirthCertificateId, String dogId, String falg) {
		// 犬只会员
		Member member = null;
		if (StringUtils.isBlank(noseId))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第三方鼻纹标识不能为空！");
		if (StringUtils.isBlank(dogBirthCertificateId) && StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "等级卡ID和犬只表ID不能同时为空！");
		}
		// 补充登记卡ID
		if (StringUtils.isBlank(dogBirthCertificateId)) {
			Dog dog = dogDao.get(dogId);
			if (dog == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dog.getMemberCode())) {
				member = memberDao.getByMemberCode(dog.getMemberCode());
			}
			if (StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
						.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (dogBirthCertificate != null) {
					dogBirthCertificateId = dogBirthCertificate.getId();
					member = memberDao.getByMemberCode(dogBirthCertificate.getMemberCode());
				}
			}
		}
		// 补充犬只ID
		if (StringUtils.isBlank(dogId)) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(dogBirthCertificateId);
			if (dogBirthCertificate == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
			if (StringUtils.isNotBlank(dogBirthCertificate.getMemberCode())) {
				member = memberDao.getByMemberCode(dogBirthCertificate.getMemberCode());
			}
			if (StringUtils.isNotBlank(dogBirthCertificate.getPedigreeCertified())) {
				Dog dog = dogDao.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
				if (dog != null) {
					dogId = dog.getId();
					member = memberDao.getByMemberCode(dog.getMemberCode());
				}

			}
		}
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬主会员不存在");
		}
		DogNose dogNose = null;
		if ("-1".equals(falg)) {
			dogNose = dao.getByDogIdODogBirthCertificateId("", dogId);
		} else {
			dogNose = dao.getByDogIdODogBirthCertificateId(dogBirthCertificateId, dogId);
		}

		DogNose dogNoseC = dao.getByNoseId(noseId);
		if (dogNose == null) {
			// 新增
			if (dogNoseC != null) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			dogNose = new DogNose();
			dogNose.setNoseId(noseId);
			dogNose.setDogBirthCertificateId(dogBirthCertificateId);
			dogNose.setDogId(dogId);
			dogNose.setNoseCode(getNextNoseCode());
			dogNose.setId(IdGen.uuid());
			dogNose.setCreateBy(loginUser());
			dogNose.setUpdateBy(loginUser());
			dogNose.setCreateDate(new Date());
			dogNose.setUpdateDate(new Date());
			dao.insert(dogNose);
			// 新增一个犬只鼻纹就增加一次抽奖机会，
			dogNoseRaffleService.addDogNoseprin(member);
		} else {
			// 修改
			if (dogNoseC != null && dogNose.getId() != dogNoseC.getId()) // 验证noseId 不重复
				// throw new ZAException(20200720, "鼻纹标识与库中信息重复！");
				return null;
			if (!dogNose.getNoseId().equals(noseId)) {// 如果相等无需修改
				dogNose.setNoseId(noseId);
				dogNose.setNoseCode(getNextNoseCode());// 下期做到修改，问下需求，显示鼻纹ID 换不换
				dogNose.setUpdateBy(loginUser());
				dogNose.setUpdateDate(new Date());
				dao.update(dogNose);
			}
		}
		return dogNose.getId();
	}

	public DogNose getByParam(DogNose dogNose) {
		return dao.getByParam(dogNose);
	}

	// 俱乐部获取当前登陆用户
	public User loginUser() {
		PartnerLoginUserInfo loginPartner = UserUtils.getLoginPartner();
		if (loginPartner.getId() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无俱乐部身份，请重新登陆！");
		}
		User user = userDao.get(loginPartner.getUserId());
		if (user == null || user.getId() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无俱乐部身份，请重新登陆！");
		}
		return user;

	}

	/**
	 * @Description： 根据出生纸id或者犬只id查询鼻纹信息
	 * 
	 * @author: yuanshuai
	 * @date: 2020/7/29 15:02
	 */
	public DogNose getByDogIdODogBirthCertificateId(String dogBirthCertificateId, String dogId) {
		return dao.getByDogIdODogBirthCertificateId(dogBirthCertificateId, dogId);
	}

	public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

	public String getNextNoseCode() {
		StringBuffer date = new StringBuffer(sdf.format(new Date()));
		int newNum = atomicNum.incrementAndGet();
		date.append(String.format("%07d", newNum));
		return date.toString();
	}

	// 静态变量存储最大值
	private static final AtomicInteger atomicNum = new AtomicInteger();

	@PostConstruct
	public void initNextNoseCode() {
		Integer maxGroupNum = dao.getMaxNoseCode();
		atomicNum.set(maxGroupNum == null ? 200 : maxGroupNum);
	}

	public void deleteRepeatByDogIds(List<String> repeatDogIds) {
		List<DogNose> dogNoseList = this.dao.selectRepeatByDogIds(repeatDogIds);
		if (!CollectionUtils.isEmpty(dogNoseList)) {
			List<DogNose> deleteNoseList = new ArrayList<>();
			Map<String, List<DogNose>> dogNoseMap = dogNoseList.stream()
					.collect(Collectors.groupingBy(nose -> nose.getDogBirthCertificateId()));
			dogNoseMap.forEach((key, val) -> {
				if (val.size() > 1) {
					// 预留一条鼻纹重复数据
					val.remove(0);
					// 将其他重复数据加入待删除集合
					deleteNoseList.addAll(val);
				}
			});
			if (!CollectionUtils.isEmpty(deleteNoseList)) {
				this.dao.deleteByIds(deleteNoseList.stream().map(DogNose::getId).collect(Collectors.toList()));
			}
		}
	}

}