//package com.cku.oa.dog.rule;
//
//import com.cku.oa.components.rule.BaseRuleService;
//import com.cku.oa.components.rule.ValidateResult;
//import com.cku.oa.components.rule.validation.dog.DogCondition;
//import com.cku.oa.components.rule.validation.dognewborn.DogNewbornCondition;
//import com.cku.oa.components.rule.validation.kennel.KennelCondition;
//import com.cku.oa.components.rule.validation.member.MemberCondition;
//import com.cku.oa.dog.dao.DogDao;
//import com.cku.oa.dog.entity.Dog;
//import com.cku.oa.dog.entity.DogNewborn;
//import com.cku.oa.kennel.dao.KennelDao;
//import com.cku.oa.kennel.entity.Kennel;
//import com.cku.oa.sys.dao.user.MemberDao;
//import com.cku.oa.sys.entity.user.Member;
//import com.cku.oa.sys.util.DateUtils;
//import com.google.common.collect.Lists;
//import com.ql.util.express.DefaultContext;
//import com.ql.util.express.ExpressRunner;
//import com.ql.util.express.IExpressContext;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.Date;
//import java.util.List;
//
///**
// * Created by laiguanglong on 2017/4/26.
// */
//@Service
//public class DogNewbornRule extends BaseRuleService {
//    private static ExpressRunner runner;
//
//    static {
//        runner = new ExpressRunner();
//    }
//
//    private static boolean isInitialRunner = false;
//
//    @Override
//    protected void initRunner() {
//        initRunner(runner);
//    }
//
//    @Override
//    protected void initRunner(ExpressRunner runner) {
//        if (isInitialRunner == true) {
//            return;
//        }
//        synchronized (runner) {
//            if (isInitialRunner == true) {
//                return;
//            }
//            try {
//                MemberCondition memberCondition = (MemberCondition) applicationContext.getBean("memberCondition");
//                DogCondition dogCondition = (DogCondition) applicationContext.getBean("dogCondition");
//                KennelCondition kennelCondition = (KennelCondition) applicationContext.getBean("kennelCondition");
//                DogNewbornCondition dogNewbornCondition = (DogNewbornCondition) applicationContext.getBean("dogNewbornCondition");
//                runner.setShortCircuit(false);
//                runner.addOperatorWithAlias("而且", "and", null);
//
//                runner.addFunctionOfServiceMethod("isFatherMemberProfessionalMember", memberCondition, "isProfessionalMember", new Class[]{Member.class}, "父犬犬主不是专业会员");
//                runner.addMacro("父犬犬主是专业会员", "isFatherMemberProfessionalMember(fatherMember)");
//                runner.addFunctionOfServiceMethod("isMotherMemberProfessionalMember", memberCondition, "isProfessionalMember", new Class[]{Member.class}, "母犬犬主不是专业会员");
//                runner.addMacro("母犬犬主是专业会员", "isMotherMemberProfessionalMember(motherMember)");
//                runner.addFunctionOfServiceMethod("isFatherMemberActiveMemberOrGroomer", memberCondition, "isActiveMemberOrGroomer", new Class[]{Member.class}, "父犬犬主不是有效会员或者美容师");
//                runner.addMacro("父犬犬主是有效会员或者美容师", "isFatherMemberActiveMemberOrGroomer(fatherMember)");
//                runner.addFunctionOfServiceMethod("isMotherMemberActiveMemberOrGroomer", memberCondition, "isActiveMemberOrGroomer", new Class[]{Member.class}, "母犬犬主不是有效会员或者美容师");
//                runner.addMacro("母犬犬主是有效会员或者美容师", "isMotherMemberActiveMemberOrGroomer(motherMember)");
//
//                runner.addFunctionOfServiceMethod("isMotherMemberActiveKennel", kennelCondition, "isActiveKennel", new Class[]{Kennel.class}, "母犬犬主没有有效犬舍");
//                runner.addMacro("母犬犬主有有效犬舍", "isMotherMemberActiveKennel(kennel)");
//
//                runner.addFunctionOfServiceMethod("isFatherDogCKUDog", dogCondition, "isCKUDog", new Class[]{Dog.class}, "父犬不是CKU注册犬");
//                runner.addMacro("父犬是CKU注册犬", "isFatherDogCKUDog(fatherDog)");
//                runner.addFunctionOfServiceMethod("isMotherDogCKUDog", dogCondition, "isCKUDog", new Class[]{Dog.class}, "母犬不是CKU注册犬");
//                runner.addMacro("母犬是CKU注册犬", "isMotherDogCKUDog(motherDog)");
//                runner.addFunctionOfServiceMethod("isFatherDogDogStateNormal", dogCondition, "isDogStateNormal", new Class[]{Dog.class}, "父犬犬只状态不为正常");
//                runner.addMacro("父犬犬只状态正常", "isFatherDogDogStateNormal(fatherDog)");
//                runner.addFunctionOfServiceMethod("isMotherDogDogStateNormal", dogCondition, "isDogStateNormal", new Class[]{Dog.class}, "母犬犬只状态不为正常");
//                runner.addMacro("母犬犬只状态正常", "isMotherDogDogStateNormal(motherDog)");
//                runner.addFunctionOfServiceMethod("isMaleDog", dogCondition, "isMaleDog", new Class[]{Dog.class}, "父犬性别不为公");
//                runner.addMacro("父犬性别为公", "isMaleDog(fatherDog)");
//                runner.addFunctionOfServiceMethod("isFemaleDog", dogCondition, "isFemaleDog", new Class[]{Dog.class}, "母犬性别不为母");
//                runner.addMacro("母犬性别为母", "isFemaleDog(motherDog)");
//                runner.addFunctionOfServiceMethod("isFatherDogNotBusinessBan", dogCondition, "isNotBusinessBan", new Class[]{Dog.class}, "父犬是禁止繁殖状态");
//                runner.addMacro("父犬不是禁止繁殖状态", "isFatherDogNotBusinessBan(fatherDog)");
//                runner.addFunctionOfServiceMethod("isMotherDogNotBusinessBan", dogCondition, "isNotBusinessBan", new Class[]{Dog.class}, "母犬是禁止繁殖状态");
//                runner.addMacro("母犬不是禁止繁殖状态", "isMotherDogNotBusinessBan(motherDog)");
//
//                runner.addFunctionOfServiceMethod("isFatherDogMonthAgeGEX", dogCondition, "isDogMonthAgeGEX", new Class[]{Dog.class, Date.class, Integer.class}, "父犬配种时年龄不大于等于$3个月");
//                runner.addMacro("父犬配种时年龄大于等于12个月", "isFatherDogMonthAgeGEX(fatherDog,breedDate,12)");
//                runner.addFunctionOfServiceMethod("isMotherDogMonthAgeGEX", dogCondition, "isDogMonthAgeGEX", new Class[]{Dog.class, Date.class, Integer.class}, "母犬配种时年龄不大于等于$3个月");
//                runner.addMacro("母犬配种时年龄大于等于12个月", "isMotherDogMonthAgeGEX(motherDog,breedDate,12)");
//                runner.addFunctionOfServiceMethod("isFatherDogMonthAgeLEX", dogCondition, "isDogMonthAgeLEX", new Class[]{Dog.class, Date.class, Integer.class}, "父犬配种时年龄不小于等于$3个月");
//                runner.addMacro("父犬配种时年龄小于等于120个月", "isFatherDogMonthAgeLEX(fatherDog,breedDate,120)");
//                runner.addFunctionOfServiceMethod("isMotherDogMonthAgeLEX", dogCondition, "isDogMonthAgeLEX", new Class[]{Dog.class, Date.class, Integer.class}, "母犬配种时年龄不小于等于$3个月");
//                runner.addMacro("母犬配种时年龄小于等于96个月", "isMotherDogMonthAgeLEX(motherDog,breedDate,96)");
//
//                runner.addFunctionOfServiceMethod("isSameDogType", dogCondition, "isSameDogType", new Class[]{Dog.class, Dog.class}, "父母犬犬种不同");
//                runner.addMacro("父母犬犬种相同", "isSameDogType(fatherDog,motherDog)");
//                runner.addFunctionOfServiceMethod("isNotCloseRelative", dogCondition, "isNotCloseRelative", new Class[]{Dog.class, Dog.class}, "父母犬是近亲关系");
//                runner.addMacro("父母犬不是近亲", "isNotCloseRelative(fatherDog,motherDog)");
//
//                runner.addFunctionOfServiceMethod("isMotherDogNotBreedInXMounth", dogNewbornCondition, "isMotherDogNotBreedInXMounth", new Class[]{DogNewborn.class, Integer.class}, "母犬距上次配种间隔少于5个月");
//                runner.addMacro("母犬在最近的5个月里没有配种", "isMotherDogNotBreedInXMounth(dogNewborn,5)");
//                runner.addFunctionOfServiceMethod("isBreedDateBeforeNow", dogNewbornCondition, "isBreedDateBeforeNow", new Class[]{Date.class}, "配种日期已大于当前日期");
//                runner.addMacro("配种日期不大于当前日期", "isBreedDateBeforeNow(breedDate)");
//
//                runner.addFunctionOfClassMethod("isInXMounth", DateUtils.class.getName(), "isInXMounth", new Class[]{Date.class, Integer.class}, "配种日期距当前日期超出$2个月");
//                runner.addMacro("配种日期距当前日期小于等于5个月", "isInXMounth(breedDate,5)");
//
//                runner.addFunctionOfServiceMethod("isZangaoFatherDogMonthAgeGEX", dogCondition, "isDogMonthAgeGEX", new Class[]{Dog.class, Date.class, Integer.class}, "藏獒父犬配种时年龄不大于等于$3个月");
//                runner.addMacro("藏獒父犬配种时年龄大于等于20个月", "isZangaoFatherDogMonthAgeGEX(fatherDog,breedDate,20)");
//                runner.addFunctionOfServiceMethod("isZangaoMotherDogMonthAgeGEX", dogCondition, "isDogMonthAgeGEX", new Class[]{Dog.class, Date.class, Integer.class}, "藏獒母犬配种时年龄不大于等于$3个月");
//                runner.addMacro("藏獒母犬配种时年龄大于等于20个月", "isZangaoMotherDogMonthAgeGEX(motherDog,breedDate,20)");
//
//                runner.addFunctionOfServiceMethod("isZangaoFatherDogHaveDogDna", dogCondition, "isHaveDogDna", new Class[]{Dog.class}, "藏獒父犬没有DNA存档");
//                runner.addMacro("藏獒父犬有DNA存档", "isZangaoFatherDogHaveDogDna(fatherDog)");
//                runner.addFunctionOfServiceMethod("isZangaoMotherDogHaveDogDna", dogCondition, "isHaveDogDna", new Class[]{Dog.class}, "藏獒母犬没有DNA存档");
//                runner.addMacro("藏獒母犬有DNA存档", "isZangaoMotherDogHaveDogDna(motherDog)");
//
//                runner.addFunctionOfServiceMethod("validateZangaoDogBreedCertified", dogNewbornCondition, "validateZangaoDogBreedCertified", new Class[]{Dog.class, Dog.class}, "配种藏獒没有繁育证书");
//                runner.addMacro("藏獒校验繁育证书", "validateZangaoDogBreedCertified(fatherDog,motherDog)");
//
//                runner.addFunctionOfServiceMethod("isZangaoNotBreedThatYear", dogNewbornCondition, "isZangaoNotBreedThatYear", new Class[]{DogNewborn.class}, "藏獒母犬当年已有配种记录");
//                runner.addMacro("藏獒母犬每年只能申请一次配种", "isZangaoNotBreedThatYear(dogNewborn)");
//
//
//            } catch (Exception e) {
//                throw new RuntimeException("初始化失败表达式", e);
//            }
//        }
//        isInitialRunner = true;
//    }
//
//    @Autowired
//    private MemberDao memberDao;
//    @Autowired
//    private KennelDao kennelDao;
//    @Autowired
//    private DogDao dogDao;
//
//    public static final String UC_POST = initStatement("父犬犬主是专业会员 " +
//            "而且 母犬犬主是专业会员 " +
//            "而且 父犬犬主是有效会员或者美容师 " +
//            "而且 母犬犬主是有效会员或者美容师 " +
//            "而且 母犬犬主有有效犬舍 " +
//            "而且 父犬是CKU注册犬 " +
//            "而且 母犬是CKU注册犬 " +
//            "而且 父犬犬只状态正常 " +
//            "而且 母犬犬只状态正常 " +
//            "而且 父犬性别为公 " +
//            "而且 母犬性别为母 " +
//            "而且 父犬不是禁止繁殖状态 " +
//            "而且 母犬不是禁止繁殖状态 " +
//            "而且 父犬配种时年龄大于等于12个月 " +
//            "而且 母犬配种时年龄大于等于12个月 " +
//            "而且 父犬配种时年龄小于等于120个月 " +
//            "而且 母犬配种时年龄小于等于96个月 " +
//            "而且 父母犬犬种相同 " +
//            "而且 父母犬不是近亲 " +
//            "而且 母犬在最近的5个月里没有配种 " +
//            "而且 配种日期不大于当前日期 " +
//            "而且 配种日期距当前日期小于等于5个月 ");
//
//    public static final String UC_POST_ZANGAO = initStatement("父犬犬主是专业会员 " +
//            "而且 母犬犬主是专业会员 " +
//            "而且 父犬犬主是有效会员或者美容师 " +
//            "而且 母犬犬主是有效会员或者美容师 " +
//            "而且 母犬犬主有有效犬舍 " +
//            "而且 父犬是CKU注册犬 " +
//            "而且 母犬是CKU注册犬 " +
//            "而且 父犬犬只状态正常 " +
//            "而且 母犬犬只状态正常 " +
//            "而且 父犬性别为公 " +
//            "而且 母犬性别为母 " +
//            "而且 父犬不是禁止繁殖状态 " +
//            "而且 母犬不是禁止繁殖状态 " +
//            "而且 父犬配种时年龄大于等于12个月 " +
//            "而且 母犬配种时年龄大于等于12个月 " +
//            "而且 父犬配种时年龄小于等于120个月 " +
//            "而且 母犬配种时年龄小于等于96个月 " +
//            "而且 父母犬犬种相同 " +
//            "而且 父母犬不是近亲 " +
//            "而且 母犬在最近的5个月里没有配种 " +
//            "而且 配种日期不大于当前日期 " +
//            "而且 配种日期距当前日期小于等于5个月 " +
//
//            "而且 藏獒父犬配种时年龄大于等于20个月 " +
//            "而且 藏獒母犬配种时年龄大于等于20个月 " +
//            "而且 藏獒父犬有DNA存档 " +
//            "而且 藏獒母犬有DNA存档 " +
//            "而且 藏獒校验繁育证书 " +
//            "而且 藏獒母犬每年只能申请一次配种 ");
//
//    /*
//    1父母犬犬主是有效专业会员
//    2母犬配种间隔校验（5个月）
//    3藏獒每年只能申请一次配种
//    4母犬主犬舍必须审核通过
//    5//近亲繁殖校验--仅会员中心检验，oa不检验，所以不放入validateDog方法里
//    6当前时间距离配种日期必须在5个月内
//
//    1父母犬为CKU犬只
//    2父母犬犬只状态都是正常
//    3父母犬配种年龄不能低于12个月
//    4种公要小于10岁，种母要小于8岁
//    5父犬性别为公，母犬性别为母
//    6父母犬犬种相同
//    7//藏獒提交配种证明时，公母犬需完成DNA位点分析(DNA存档)
//    8//藏獒配种需大于20个月
//    9//藏獒公母犬一方为2016年1月1日之后出生的犬只，繁殖人需要参加一次繁育考试，取得繁育证书
//    10//业务禁止校验
//     */
//
//
//    public ValidateResult validate(DogNewborn po) throws Exception {
//        IExpressContext<String, Object> expressContext = buildUcPostContext(po);
//        List<String> errorInfoList = Lists.newArrayList();
//        Boolean dogResult = (Boolean) runner.execute(UC_POST, expressContext, errorInfoList, true, true);
//        if (!dogResult.booleanValue()) {
//            return buildValidateResult(dogResult, errorInfoList);
//        }
//        return new ValidateResult(true, "");
//    }
//
//    public static ValidateResult buildValidateResult(Boolean result, List<String> errorInfoList) {
//        StringBuilder sb = new StringBuilder();
//        errorInfoList.forEach((errorInfo) -> {
//            sb.append(errorInfo).append(",");
//        });
//        sb.append("不能办理该业务");
//        return new ValidateResult(result.booleanValue(), sb.toString());
//    }
//
//    private IExpressContext<String, Object> buildUcPostContext(DogNewborn po) {
//        IExpressContext<String, Object> validateContext = new DefaultContext<String, Object>();
//        Member fatherMember = memberDao.getByMemberCode(po.getMdogOwnerCode());
//        Member motherMember = memberDao.getByMemberCode(po.getFdogOwnerCode());
//        validateContext.put("fatherMember", fatherMember);
//        validateContext.put("motherMember", motherMember);
//        Kennel kennel = kennelDao.getKennelByMemberCode(po.getFdogOwnerCode());
//        validateContext.put("kennel", kennel);
//        Dog fatherDog = dogDao.getByPedigreeCertifiedCode(po.getMalePedigreeCertified());
//        Dog motherDog = dogDao.getByPedigreeCertifiedCode(po.getFemalePedigreeCertified());
//        validateContext.put("fatherDog", fatherDog);
//        validateContext.put("motherDog", motherDog);
//        validateContext.put("breedDate", po.getBreedDate());
//        validateContext.put("dogNewborn", po);
//        return validateContext;
//    }
//
//}