/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 111Entity
 * @author wangjie
 * @version 2018-11-05
 */
public class DogOwner extends DataEntity<DogOwner> {

	private static final long serialVersionUID = 1L;
	private String identificationFlag;		// 芯片号
	private String cabPassport;		// 护照号
	private String dogOwnerName;		// 宠物主人姓名
	private String dogOwnerMobile;		// 犬主电话
	private String dogOwnerAddress;		// 犬主地址
	private Date activateDate;		// 激活时间

	public DogOwner() {
		super();
	}

	public DogOwner(String id){
		super(id);
	}

	@Length(min=1, max=64, message="芯片号长度必须介于 1 和 64 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min=1, max=20, message="护照号长度必须介于 1 和 20 之间")
	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	@Length(min=1, max=20, message="宠物主人姓名长度必须介于 1 和 20 之间")
	public String getDogOwnerName() {
		return dogOwnerName;
	}

	public void setDogOwnerName(String dogOwnerName) {
		this.dogOwnerName = dogOwnerName;
	}

	@Length(min=1, max=20, message="犬主电话长度必须介于 1 和 20 之间")
	public String getDogOwnerMobile() {
		return dogOwnerMobile;
	}

	public void setDogOwnerMobile(String dogOwnerMobile) {
		this.dogOwnerMobile = dogOwnerMobile;
	}

	@Length(min=1, max=100, message="犬主地址长度必须介于 1 和 100 之间")
	public String getDogOwnerAddress() {
		return dogOwnerAddress;
	}

	public void setDogOwnerAddress(String dogOwnerAddress) {
		this.dogOwnerAddress = dogOwnerAddress;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="激活时间不能为空")
	public Date getActivateDate() {
		return activateDate;
	}

	public void setActivateDate(Date activateDate) {
		this.activateDate = activateDate;
	}

}