/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只颜色及标志Entity
 * @author lgl
 * @version 2016-08-05
 */
public class DogColorMark extends DataEntity<DogColorMark> {
	
	private static final long serialVersionUID = 1L;
	private String dogColorMarkCode;		// 犬颜色及标记编码
	private String dogColorMarkCn;		// 犬颜色及标记(中文)
	
	public DogColorMark() {
		super();
	}

	public DogColorMark(String id){
		super(id);
	}

	@Length(min=0, max=20, message="犬颜色及标记编码长度必须介于 0 和 20 之间")
	public String getDogColorMarkCode() {
		return dogColorMarkCode;
	}

	public void setDogColorMarkCode(String dogColorMarkCode) {
		this.dogColorMarkCode = dogColorMarkCode;
	}
	
	@Length(min=0, max=50, message="犬颜色及标记(中文)长度必须介于 0 和 50 之间")
	public String getDogColorMarkCn() {
		return dogColorMarkCn;
	}

	public void setDogColorMarkCn(String dogColorMarkCn) {
		this.dogColorMarkCn = dogColorMarkCn;
	}
	
}