/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场年龄组别Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestClass extends DataEntity<ContestClass> {
	
	private static final long serialVersionUID = 1L;
	private String classNo;		// 编号
	private String code;		// 代码
	private String name;		// 名称
	private String sortNo;		// 排序
	private String gradeTypeNo;		// 成绩组别类型
	private String languageNo;		// 语言
	
	public ContestClass() {
		super();
	}

	public ContestClass(String id){
		super(id);
	}

	@Length(min=1, max=11, message="编号长度必须介于 1 和 11 之间")
	public String getClassNo() {
		return classNo;
	}

	public void setClassNo(String classNo) {
		this.classNo = classNo;
	}
	
	@Length(min=1, max=32, message="代码长度必须介于 1 和 32 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=1, max=255, message="名称长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=11, message="排序长度必须介于 1 和 11 之间")
	public String getSortNo() {
		return sortNo;
	}

	public void setSortNo(String sortNo) {
		this.sortNo = sortNo;
	}
	
	@Length(min=1, max=4, message="成绩组别类型长度必须介于 1 和 4 之间")
	public String getGradeTypeNo() {
		return gradeTypeNo;
	}

	public void setGradeTypeNo(String gradeTypeNo) {
		this.gradeTypeNo = gradeTypeNo;
	}
	
	@Length(min=1, max=11, message="语言长度必须介于 1 和 11 之间")
	public String getLanguageNo() {
		return languageNo;
	}

	public void setLanguageNo(String languageNo) {
		this.languageNo = languageNo;
	}
	
}