/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.contest.entity.ContestWinner;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 赛场成绩DAO接口
 * @author yuanshuai
 * @version 2020-10-12
 */
@MyBatisDao
public interface ContestWinnerDao extends CrudDao<ContestWinner> {

	Integer checkDataUnique(ContestWinner contestWinner);

	Integer updateWinner(ContestWinner contestWinner);

	List<ContestWinner> getWinnerByContest(@Param("contestId") String contestId,@Param("type") String type);

	Map<String,String> getWinnerMapByDogAndContest(@Param("exhibitNo")String exhibitNo, @Param("contestNo")String contestNo);
}