<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员支付流水管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:充值信息</a></li>
	</ul>
<ul>
	<form:form id="searchForm" modelAttribute="paymentOrder" action="${ctxSchools}/schoolsAccountManagement/myRecord" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水号</th>
				<th>实付金额</th>
				<th>收支类型</th>
				<th>支付类型</th>
				<th>付款日期</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOrder">
			<tr>
				<td>
					${fns:escapeHtml(paymentOrder.orderCode)}
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.totalPrice)}
				</td>
				<td>
					<font color="red">账户充值</font>
				</td>
				<td>
					${fns:getDictLabel(paymentOrder.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrder.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	
	<span>
		<input id="btnCancel" class="btn" type="button" value="返回上一页" onclick="history.go(-1)"/>
	</span>
</ul>
</body>
</html>