<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍登记</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
						loading('正在提交，请稍等...');
						form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<h2>犬舍信息录入</h2>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<div style = "clear:both;"></div>
	<form:form id="inputForm" modelAttribute="member" action="${ctxPartner}/clubMember/saveKennel" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="memberType"/>
		<form:hidden path="memberCode"/>
		<sys:message content="${message}"/>
		<div id="kennel">
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input path="kennel.name" htmlEscape="false"    onBlur="checkKennel()"  minlength="2" maxlength="4" class="input-xlarge  kennel" title="请输入2-4个字的犬舍名称"/>
				<span><font color="red">仅限中文*</font></span>
				<script type="text/javascript">
					function checkKennel() {
						kennelName = $(".kennel").val();
						var str = kennelName.trim();
						if(str.length!=0){
							reg= /^[\u4e00-\u9fa5]+$/;
							if(!reg.test(str)){
								$.jBox.alert("请输入中文,勿含空格或其他特殊符号!");
								$(".kennel").attr("value", '');
								return false;
							}
						}
						if(str.length!=0){
							if(str.indexOf("犬舍")!=-1){
								$.jBox.alert("中文名称请勿包含'犬舍'!");
								$(".kennel").attr("value", '');
								return false;
							}
						}
						if (str!= "") {
							var url="${ctxPartner}/clubMember/nameCheck?name="+kennelName;
							$.ajax({
								type: "POST",
								timeout:1000, 
								contentType:"application/x-www-form-urlencoded; charset=UTF-8",
				                dataType:"json",
				                url:encodeURI(url, "UTF-8"),
				                async: false,
				                error: function(request, textStatus, errorThrown) {
				                    alert("请求失败！");
									$(".kennel").attr("value", '');
				                },
				                success: function(data) {
				                	if(data.rc == false){
				                		$.jBox.alert(data.msg);
										$(".kennel").attr("value", '');
										return false;
				                	}
				                }
							});
						}else{
							$.jBox.alert("请输入有效中文");
							$(".kennel").attr("value", '');
							return false;
						}
					}
					
					
					
				</script>
			 </div>
		 </div>
		 <div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				 <form:input path="kennel.nameEn" htmlEscape="false" onBlur="checkEn(this.value,1)"  maxlength="30" class="input-xlarge  fciName"/>
				<span><font color="red">仅限输入英文*</font></span>
			 </div>
		 </div>
		<%--  <div class="control-group">
			<label class="control-label">备用犬舍英文名：</label>
			<div class="controls">
				  <form:input path="kennel.fciNameBackup" htmlEscape="false"  onBlur="checkEn(this.value,2)" maxlength="30" class="input-xlarge  fciNameBackup"/>
			 	<span><font color="red">仅限输入英文*</font></span>
			 </div>
		 </div> --%>
		 <div class="control-group">
			<label class="control-label">犬舍开始日期：</label>
			<div class="controls">
				<input  type="text" readonly="readonly"  maxlength="20" class="input-medium"
					value="<fmt:formatDate value="${date}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍结束日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium "/>
			</div>
		</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript">
		function checkEn(str2,i){
				var str=str2.trim();
				if(str.length!=0){
					reg= /^[A-Za-z\s]+$/;
					if(i==1){
						if(!reg.test(str)){
							alert("请输入英文符号!");
								$(".fciName").val("");
								return false;
						}
					}else{
						if(!reg.test(str)){
							alert("请输入英文符号!");
								$(".fciNameBackup").val("");
								return false;
						}
						/* $.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/nameEnBackCheck?name="+str,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("犬舍备用英文名已经存在！请重新输入");
									$(".fciNameBackup").attr("value", '');
			                	}
			                }
						}); */
					
					}
				}
		}
	</script>
</body>
</html>