<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>计划任务执行日志管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/tasklog/taskLog/">计划任务执行日志列表</a></li>
		<shiro:hasPermission name="tasklog:taskLog:edit"><li><a href="${ctx}/tasklog/taskLog/form">计划任务执行日志添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="taskLog" action="${ctx}/tasklog/taskLog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>任务名称：</label>
				<form:input path="jobName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>任务组名：</label>
				<form:input path="jobGroup" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>执行类型：</label>
				<form:select path="executeType" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('executeType')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>执行结果标识：</label>
				<form:select path="successState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('executeState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>执行时间：</label>
                <input name="executeTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${taskLog.executeTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>任务名称</th>
				<th>任务组名</th>
				<th>执行类型</th>
				<th>执行时间</th>
				<th>执行结果标识</th>
				<th>执行成功条数</th>
				<shiro:hasPermission name="tasklog:taskLog:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="taskLog">
			<tr>
				<td>
					${taskLog.jobName}
				</td>
				<td>
					${taskLog.jobGroup}
				</td>
				<td>
					${fns:getDictLabel(taskLog.executeType, 'executeType', '')}
				</td>
				<td>
					<fmt:formatDate value="${taskLog.executeTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
				<c:if test="${taskLog.successState==0}"><font color="green"></c:if>
				<c:if test="${taskLog.successState==1}"><font color="red"></c:if>
                       ${fns:getDictLabel(taskLog.successState, 'executeState', '')}
                    <c:if test="${taskLog.successState==0}"></font></c:if>
                    <c:if test="${taskLog.successState==1}"></font></c:if>
				</td>
				<td>
                    ${taskLog.successCount}
                </td>
				<shiro:hasPermission name="tasklog:taskLog:edit"><td>
    				<a href="${ctx}/tasklog/taskLog/form?id=${taskLog.id}">修改</a>
					<a href="${ctx}/tasklog/taskLog/delete?id=${taskLog.id}" onclick="return confirmx('确认要删除该计划任务执行日志吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>