<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>比赛成绩</title>
	<meta name="decorator" content="default"/>	
	<style type="text/css">
		.mouseOver{
			background-image: none!important;
			background-color: #363f68!important;
			color:#fff;
			cursor:pointer;
		}
		.mouseOut{
			
		}
	</style>
	<script type="text/javascript">
		function cov(value, dataType) {
		  switch(dataType) {
		   case "int":
		    return parseInt(value);
		    break
		   case "float":
		    return parseFloat(value);
		    break
		   case "date":
		    return Date.parse(value);
		    break
		   default:
		    return value.toString();
		  }
		 }

		function colsSoft(col, dataType) {
		  return function compareTrs(tr1, tr2) {
		   value1 = cov(tr1.cells[col].innerHTML, dataType);
		   value2 = cov(tr2.cells[col].innerHTML, dataType);
		   if (value1 < value2) {
		    return -1;
		   } else if (value1 > value2) {
		    return 1;
		   } else {
		    return 0;
		   }
		  };
		 }

		function tableSoft(tableId, col, dataType) {
		  var table = document.getElementById(tableId);
		  var tbody = table.tBodies[0];
		  var tr = tbody.rows;
		  var trValue = new Array();
		  for (var i=0; i<tr.length; i++ ) {
		   trValue[i] = tr[i];  //将表格中各行的信息存储在新建的数组中
		  }
		  if (tbody.sortCol == col) {
		   trValue.reverse(); //如果该列已经进行排序过了，则直接对其反序排列
		  } else {
		   trValue.sort(colsSoft(col, dataType));  //进行排序
		  }
		  var fragment = document.createDocumentFragment();  //新建一个代码片段，用于保存排序后的结果
		  for (var i=0; i<trValue.length; i++ ) {
		   fragment.appendChild(trValue[i]);
		  }
		  tbody.appendChild(fragment); //将排序的结果替换掉之前的值
		  tbody.sortCol = col;
		 }
	</script>
</head>
<body>
	<c:choose>
	 <c:when test="${!empty showResult}">
	<p style="text-align:center;font-size:24px;line-height:30px;"><b style="color:#363f68;">${fns:escapeHtml(showCode)}</b><b>比赛成绩</b></p>	
	<p><input type="button" class="btn btn-primary" value="返回" onClick="javascript:history.go(-1)"/> 			
	
	<table id="showResult" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 0, 'int')">秩序号</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 1)">血统证书号</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 2)">CC</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 3)">CACIB</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 4)">P/BOB</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 5)">P/BIG</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 6)">P/BIS</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 7, 'int')">本场积分</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 8, 'int')">年龄组别</th>
				<th width="400" style="text-align:center;"  onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 9)">裁判</th>
				<th style="text-align:center;" onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="tableSoft('showResult', 10)">活动区域</th>			
			</tr>
		</thead>
		<tbody>
			<c:forEach items="${showResult}" var="showResult">
			<tr>			
				<td style="text-align:center;">${fns:escapeHtml(showResult.order_code)}</td>
			
			<!-- <td style="text-align:center;"><a href="${ctx }/statistics/activity/showResult/dogView?pedigreeCertified=${fns:escapeHtml(showResult.pedigree_certified)}">${fns:escapeHtml(showResult.pedigree_certified)}</a></td>-->
				<td style="text-align:center;">${fns:escapeHtml(showResult.pedigree_certified)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.result_cc)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.result_cacib)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.result_bob)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.result_big)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.result_bis)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.show_result)}</td>
				<td style="text-align:center;">${fns:getDictLabels(showResult.age_group, 'show_age_group', '')}</td>								
				<td style="text-align:center;">${fns:escapeHtml(showResult.referee)}</td>
				<td style="text-align:center;">${fns:escapeHtml(showResult.race_lap)}</td>
			</tr>
			</c:forEach>	
		</tbody>		
	</table>	
	</c:when>
	 <c:otherwise>
	 	<p style="text-align:center;font-size:24px;line-height:30px;"><b>没有查询到</b><b style="color:#363f68;">${fns:escapeHtml(showCode)}</b><b>相关的成绩记录。</b></p>
	 	<p><input type="button" class="btn btn-primary" value="返回" onClick="javascript:history.go(-1)"/>
	 </c:otherwise>
	 	
	 </c:choose>
</body>
</html>