<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展秩序册管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"犬展秩序册", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" action="${ctx}/show/showReportScore/import" method="post" enctype="multipart/form-data"
		  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
		<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
		<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		<a href="${ctx}/show/showReportScore/import/template">下载模板</a>
	</form>
</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showReportScore/">犬展秩序册列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showReportScore" action="${ctx}/show/showReportScore/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>秩序号：</label>
				<form:input path="orderNumber" htmlEscape="false" maxlength="10" class="input-medium"/>
			</li>
			<li><label>犬主中文名：</label>
				<form:input path="dogOwnerZh" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>血统证书：</label>
				<form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬展编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="秩序册导入"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>秩序号</th>
				<th>犬展编号</th>
				<th>犬主中文名</th>
				<th>会员号</th>
				<th>犬种</th>
				<th>年龄组别</th>
				<th>血统证书号</th>
				<th>裁判</th>
				<th>活动区域</th>

				<shiro:hasPermission name="show:showReportScore:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showReportScore">
			<tr>

				<td>
					${showReportScore.orderNumber}
				</td>
				<td>
					${showReportScore.showCode}
				</td>
				<td>
					${showReportScore.dogOwnerZh}
				</td>
				<td>
					${showReportScore.dogOwnerCode}
				</td>
				<td>
					${showReportScore.dogTypeZh}
				</td>
				<td>
						${fns:getDictLabel(showReportScore.dogYearGroup, 'show_age_group', '')}
				</td>
				<td>
						${showReportScore.pedigreeCertifiedCode}
				</td>
				<td>
						${showReportScore.judgeName}
				</td>
				<td>
						${showReportScore.showCircle}
				</td>

				<td>
					<a href="${ctx}/show/showReportScore/form?id=${showReportScore.id}">查看</a>
					<shiro:hasPermission name="show:showReportScore:edit">
    				<a href="${ctx}/show/showReportScore/editForm?id=${showReportScore.id}">修改</a>
					<a href="${ctx}/show/showReportScore/delete?id=${showReportScore.id}" onclick="return confirmx('确认要删除该犬展秩序册吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>