<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>CKU审查员管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/judgecertificate/showJudgeCertificate/">CKU审查员列表</a></li>
    <shiro:hasPermission name="judgecertificate:showJudgeCertificate:edit">
        <li><a href="${ctx}/judgecertificate/showJudgeCertificate/edit">CKU审查员添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="showJudgeCertificate" action="${ctx}/judgecertificate/showJudgeCertificate/"
           method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>中文名称：</label>
            <form:input path="name" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>英文名称：</label>
            <form:input path="nameEn" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>CKU审查员类型：</label>
            <form:select path="certificateType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('certificate_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>证书号：</label>
            <form:input path="judgeCertificate" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>是否在页面展示：</label>
            <form:select path="visibleFlag" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('visible_flag')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>中文名称</th>
        <th>英文名称</th>
        <th>证书号</th>
        <th>审查员类型</th>
        <th>签发日期</th>
        <th>结束日期</th>
        <th>是否在页面展示</th>
        <th>排序</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="showJudgeCertificate">
        <tr>
            <td>
                <a href="${ctx}/judgecertificate/showJudgeCertificate/form?id=${showJudgeCertificate.id}">
                    ${showJudgeCertificate.name}
                </a>
            </td>
            <td>
                    ${showJudgeCertificate.nameEn}
            </td>
            <td>
                    ${showJudgeCertificate.judgeCertificate}  <c:if test="${showJudgeCertificate.certificateType eq '8'}">(${fns:getDictLabel(showJudgeCertificate.groomingDogGroup, 'grooming_judge_dog_group', '')})</c:if>
            </td>
            <td>
                    ${fns:getDictLabel(showJudgeCertificate.certificateType, 'certificate_type', '')}
            </td>
            <td>
                <fmt:formatDate value="${showJudgeCertificate.signDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <fmt:formatDate value="${showJudgeCertificate.endDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${fns:getDictLabel(showJudgeCertificate.visibleFlag, 'visible_flag', '')}
            </td>
            <td>
                    ${showJudgeCertificate.sort}
            </td>
            <td>
                <shiro:hasPermission name="judgecertificate:showJudgeCertificate:view">
                    <a href="${ctx}/judgecertificate/showJudgeCertificate/view?id=${showJudgeCertificate.id}">查看</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="judgecertificate:showJudgeCertificate:edit">
                    <a href="${ctx}/judgecertificate/showJudgeCertificate/edit?id=${showJudgeCertificate.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="judgecertificate:showJudgeCertificate:del">
                    <a href="${ctx}/judgecertificate/showJudgeCertificate/delete?id=${showJudgeCertificate.id}"
                       onclick="return confirmx('确认要删除吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>