<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>CKU培训部-活动录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#schoolsDiv").hide();
			// 回显报名方式
			var registerType = '${fns:escapeHtml(groomerShow.registerType)}';
			var registerTypeArray = registerType.split(",");
			$.each(registerTypeArray, function(i,val) {
				$("input[type=checkbox][name='registerType'][value="+val+"]").attr("checked",'checked');
				if(val == 'school'){
					$("#schoolsDiv").show();
					// 回显考试地点
					var schools = '${fns:escapeHtml(groomerShow.schools)}';
					var schoolsArray = schools.split(",");
					$.each(schoolsArray, function(i,val) {
						$("#schools").find("option[value='"+val+"']").attr("selected",true);
				    });
					$("#schools").trigger("change");
				}
		    });
			
			//回显裁判信息
 			var referee = '${fns:escapeHtml(groomerShow.referee)}';
			var refereeArray = referee.split(",");
			$.each(refereeArray, function(i,val) {
				$("#referee").find("option[value='"+val+"']").attr("selected",true);
		    });
			$("#referee").trigger("change");

			//回显参赛级别
			let showCategory = '${fns:escapeHtml(groomerShow.showCategory)}';
			changeLevel(showCategory);
			var testLevel = '${fns:escapeHtml(groomerShow.testLevel)}'.split(",");
			if (testLevel.length > 0) {
				//国际宠物美容师认证
				if (showCategory == '2') {
					$.each(testLevel, function (index, item) {
						$("#otherLevelT input[type=checkbox][name='testLevel'][value='" + item + "']").attr("checked", 'checked');
					});
				} else if (showCategory == '3') {
					//宠物造型师&国际宠物美容师认证
					$.each(testLevel, function (index, item) {
						$("#otherLevelR input[type=checkbox][name='testLevel'][value='" + htmlDecode(item) + "']").attr("checked", 'checked');
					});
				}else if (showCategory == '8') {
					//伴侣猫洗护师资格认证
					$.each(testLevel, function (index, item) {
						$("#otherLevelCatNurse input[type=checkbox][name='testLevel'][value='" + htmlDecode(item) + "']").attr("checked", 'checked');
					});
				} else {
					$.each(testLevel, function (index, item) {
						$("input[type=checkbox][name='testLevel'][value=" + item + "]").attr("checked", 'checked');
					});
				}
			}
		});

		function changeLevel(showCategory) {
			console.log(showCategory);
			// 清除级别
			$("input[name=testLevel]").each(function () {
				$(this).attr("checked", false);
			});
			//选中的值
			//美容师资格认证
			if (showCategory == '1') {
				$("#otherLevelO").show();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelCatNurse").hide();
			}
			//国际宠物美容师认证
			if (showCategory == '2') {
				$("#otherLevelO").hide();
				$("#otherLevelT").show();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelCatNurse").hide();
			}
			//宠物造型师&国际宠物美容师认证
			if (showCategory == '3') {
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").show();
				$("#otherLevelNurse").hide();
				$("#otherLevelCatNurse").hide();
			}
			if (showCategory == '4') {
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").show();
				$("#otherLevelCatNurse").hide();
			}
			if (showCategory == '8') {
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelCatNurse").show();
			}
		}
		
		function htmlDecode(str){
			var s = "";
			if(str.length == 0) return "";
			s = str.replace(/&amp;/g,"&");
			s = s.replace(/&lt;/g,"<");
			s = s.replace(/&gt;/g,">");
			s = s.replace(/&nbsp;/g," ");
			s = s.replace(/'/g,"\'");
			s = s.replace(/"/g,"\"");
			return s;
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShow/view?id=${groomerShow.id}">活动查看</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="groomerShow"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerShow.showCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名方式：</label>
			<div class="controls">
				<input name="registerType" maxlength="50" class="input-xlarge required" type="checkbox" value="app" disabled="true"/>
                <label>公开报名</label>
                <input  name="registerType" maxlength="50" class="input-xlarge required" type="checkbox" value="school" disabled="true"/>
                <label>考点报名</label>
			</div>
		</div>
		
		<div id="schoolsDiv" class="control-group">
			<label class="control-label">考试地点：</label>
			<div class="controls">
                <form:select id="schools" path="schools" class="input-xxlarge required" multiple="true" disabled="true">
                	<form:options items="${schools}" itemLabel="schoolNameCn" itemValue="id" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">开始日期：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerShow.startTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束日期：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerShow.endTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动名称：</label>
			<div class="controls">
				${fns:escapeHtml(groomerShow.showName) }
			</div>
		</div>
		<div class="control-group" style="width:80%">
			<label class="control-label">活动图片：</label>
			<div class="controls">
				<sys:singleImgUpload module="member"  imgId="${groomerShow.showPhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="showPhoto" id="showPhoto" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#showPhoto").val(response.id);
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动地点：</label>
			<div class="controls">
				${fns:escapeHtml(groomerShow.showAddress) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动类型：</label>
			<div class="controls">
				${fns:getDictLabel(groomerShow.showType, 'groomer_show_type', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名截止时间：</label>
			<div class="controls">
				<fmt:formatDate  value="${groomerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
				<label class="control-label">裁判：</label>
				<div class="controls">
	                <form:select id="referee" path="referee" class="input-xxlarge required" multiple="true" disabled="true">
	                	<form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="id" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
		<%-- <div class="control-group">
			<label class="control-label">报名优惠：</label>
			<div class="controls">
				<form:input path="discount" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div> --%>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				${fns:escapeHtml(groomerShow.fee) }
				${groomerShow.freeFee eq true?'免费报名':''}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div id="otherLevelO" class="controls" disabled="true">
				<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="none" disabled="true"/>
				<label>无</label>
				<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="C" disabled="true"/>
				<label>C</label>
				<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="B" disabled="true"/>
				<label>B</label>
				<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="A" disabled="true"/>
				<label>A</label>
				<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="MASTER" disabled="true"/>
				<label>教师</label>
			</div>
			<div id="otherLevelT" class="controls">
				<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="国际宠物美容师" disabled="true"/>
				<label>国际宠物美容师</label>
			</div>
			<div id="otherLevelR" class="controls" disabled="true">
				<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="国际宠物美容师" disabled="true"/>
				<label>国际宠物美容师</label>
				<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="宠物造型师&国际宠物美容师" disabled="true"/>
				<label>宠物造型师&国际宠物美容师</label>
			</div>
			<div id="otherLevelNurse" class="controls">
				<form:checkboxes path="testLevel" items="${fns:getDictList('groomer_nurse_level')}" itemLabel="label" itemValue="value" htmlEscape="false" disabled="true"/>
			</div>
			<div id="otherLevelCatNurse" class="controls">
				<form:checkboxes path="testLevel" items="${fns:getDictList('groomer_cat_nurse_level')}" itemLabel="label" itemValue="value" htmlEscape="false" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(groomerShow.remarks) }
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>