<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只精子管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dog/dogSemen/">犬只精子列表</a></li>
    <li class="active"><a href="${ctx}/dog/dogSemen/form?id=${dogSemen.id}">犬只精子</a></li>
</ul>
<br/>
<form:form class="form-horizontal">
    <div class="control-group">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.pedigreeCertified) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号码：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.dogChip) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.dogBreed) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.dogName) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.memberName) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">会员号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemen.memberCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">精子信息：</label>
        <div class="controls">
            <table class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th>原精子编号</th>
                    <th>CKU精子编号</th>
                    <th>状态</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>
                            ${fns:escapeHtml(dogSemen.originalSemenCode) }
                    </td>
                    <td>
                            ${fns:escapeHtml(dogSemen.semenCode) }
                    </td>
                    <td>
                        <c:if test="${empty dogSemen.breedCertifiedCode }">有效</c:if>
                        <c:if test="${not empty dogSemen.breedCertifiedCode }">
                            在配种证明号为${fns:escapeHtml(dogSemen.breedCertifiedCode) }的配种中使用
                        </c:if>
                    </td>
                <tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>