<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片变更管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
                    save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#hiddenDiv2").hide();
			$("#hiddenDiv3").hide();
			$("#hiddenDiv4").hide();
			$("input:radio[name='check']").change(function (){
	            var flag = $('input[name="check"]:checked ').val();
	            if(flag=='1'){
	            	$("#hiddenDiv2").hide();
	            	$("#hiddenDiv3").hide();
	            	$("#hiddenDiv4").hide();
	            	$("#hiddenDiv1").show();
	            }
	            if(flag=='2'){
	            	$("#hiddenDiv2").show();
                    $("#hiddenDiv1").hide();
                    $("#hiddenDiv3").hide();
                    $("#hiddenDiv4").hide();
                    $("#dogId").val('');
	            }
	            if(flag=='3'){
	            	$("#hiddenDiv3").show();
                    $("#hiddenDiv1").hide();
                    $("#hiddenDiv2").hide();
                    $("#hiddenDiv4").hide();
                    $("#dogId").val('');
	            }
	            if(flag=='4'){
	            	$("#hiddenDiv4").show();
                    $("#hiddenDiv1").hide();
                    $("#hiddenDiv2").hide();
                    $("#hiddenDiv3").hide();
                    $("#dogId").val('');
	            }
	        });
		});
		function save(){
			var flag = $('input[name="check"]:checked ').val();
			var dogId = $("#dogId").val();
            if(flag=='1'){
            	if(dogId==''){
                    alert("请先查询出犬只信息！");
                    $('#dogId').val('');
                    return;
                }
            }
            if(flag=='2'){
            	
            }
           var frm = $("#inputForm");
           var dataPara = util.getFormJson(frm);
           $.ajax({
               url: '${ctx}/dogchipchangemanage/dogChipChange/orderSave',
               type: 'POST',
               data: dataPara,
               async:false,
               success: function(data){
                   if(data.rc==0){
					   alert("订单录入成功！");
                       parent.isYes = true;
                       parent.layer.closeAll(); 
                   }else{
					   alert("提交失败,错误信息："+data.msg);
				   }
               }
           });
           loading('正在提交，请稍等...');
       }
	   function closeLayer(){
            parent.isYes = false;
            parent.layer.closeAll();
       }
	   function getDogByPedigreeCertified(){
	           var pedigreeCertified = $("#pedigreeCertified").val();
	           if(pedigreeCertified==''){
	               alert("请填写血统证书号进行证书有效性验证！");
	               return;
	           }
	           $.post('${ctx}/dogexport/dogPedigreeCertifiedExport/getDogByPedigreeCertified', {
	               pedigreeCertified: pedigreeCertified
	           }, function(data) {
	        	   if(data.dogId!="" && data.dogId!=undefined){
	        		   $("#pedigreeCertifiedValid").text('有效');
	        	       $("#pedigreeCertifiedValid").css("color","green");
	        	       $("#dogId").val(data.dogId);
	        	       $("#chipCodeOld").val(data.identificationFlag);
	        	   } else {
	        		   $("#pedigreeCertifiedValid").text('无效');
                       $("#pedigreeCertifiedValid").css("color","red");
                       $("#dogId").val('');
                       $("#chipCodeOld").val('');
	        	   }
	           });
	    }
		function getMessageByBirthCerRegCode(){
            var birthCerRegCode = $("#birthCerRegCode").val();
            if(birthCerRegCode==''){
                alert("请填写出生纸编号进行出生纸有效性验证！");
                return;
            }
            $.post('${ctx}/birthcertificate/dogBirthCertificate/getMessageByBirthCerRegCode', {
            	birthCerRegCode: birthCerRegCode
            }, function(data) {
                if(data=='success'){
                    $("#birthCerRegCodeValid").text('有效');
                    $("#birthCerRegCodeValid").css("color","green");
                    $("#birthCerRegCodeHid").val($("#birthCerRegCode").val());
                } else {
                    $("#birthCerRegCodeValid").text('无效');
                    $("#birthCerRegCodeValid").css("color","red");
                }
            });
        }
		function getMessageByShowAppraisalCode(){
            var showAppraisalCode = $("#showAppraisalCode").val();
            if(showAppraisalCode==''){
                alert("请填写犬展鉴定编号进行赛场鉴定记录关联！");
                return;
            }
            $.post('${ctx}/dogappraisal/dogAppraisal/getMessageByShowAppraisalCode', {
				showAppraisalCode: showAppraisalCode
            }, function(data) {
                if(data.flag=='success'){
					$("#chipCodeNew").val(data.dogChip);
                    $("#showAppraisalCodeValid").text('有效');
                    $("#showAppraisalCodeValid").css("color","green");
                    $("#birthCerRegCodeHid").val($("#showAppraisalCode").val());
                } else {
                    $("#showAppraisalCodeValid").text('无效');
                    $("#showAppraisalCodeValid").css("color","red");
                }
            });
        }
		function getMessageByOverseasPedigreeCertified(){
            var overseasPedigreeCertified = $("#overseasPedigreeCertified").val();
            if(overseasPedigreeCertified==''){
                alert("请填写外国血统证书号进行证书换发记录关联！");
                return;
            }
            $.post('${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/getMessageByOverseasPedigreeCertified', {
				overseasPedigreeCertified: overseasPedigreeCertified
            }, function(data) {
                if(data.flag=='success'){
					$("#chipCodeNew").val(data.identificationFlag);
                    $("#overseasPedigreeCertifiedValid").text('有效');
                    $("#overseasPedigreeCertifiedValid").css("color","green");
                    $("#birthCerRegCodeHid").val($("#overseasPedigreeCertified").val());
                } else {
                    $("#overseasPedigreeCertifiedValid").text('无效');
                    $("#overseasPedigreeCertifiedValid").css("color","red");
                }
            });
        }
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="dogChipChange" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="runningNumber"/>
		<form:hidden path="dogId"/>
		<input type="hidden" id="birthCerRegCodeHid" name="birthCerRegCodeHid"/>
		<sys:message content="${message}"/>
		<div style="height: 20px;">
		</div>
		<div class="control-group">
		    <label class="control-label"> 登记类型：</label>
		    <div class="controls">
                <input type="radio" name="check" checked="checked" value="1"/><label>血统证书号</label>&nbsp;&nbsp;
                <input type="radio" name="check" value="2"><label>出生纸编号</label>
                <input type="radio" name="check" value="3"><label>犬展鉴定编号</label>
                <input type="radio" name="check" value="4"><label>外国血统证书号</label>
            </div>
		</div>
		<div class="control-group" id="hiddenDiv1">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<input type="text" id="pedigreeCertified" name="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<input  class="btn btn-primary" type="button" value="查" onclick="getDogByPedigreeCertified();"/>
				<font id="pedigreeCertifiedValid" ></font>
			</div>
		</div>
		<div class="control-group" id="hiddenDiv2">
            <label class="control-label">出生纸编号：</label>
            <div class="controls">
                <input type="text" id="birthCerRegCode" name="birthCerRegCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
                <input id="btnSubmit" class="btn btn-primary" type="button" value="查" onclick="getMessageByBirthCerRegCode();"/>
                <font id="birthCerRegCodeValid" ></font>
            </div>
        </div>
		<div class="control-group" id="hiddenDiv3">
            <label class="control-label">犬展鉴定编号：</label>
            <div class="controls">
                <input type="text" id="showAppraisalCode" name="showAppraisalCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
                <input id="btnSubmit" class="btn btn-primary" type="button" value="查" onclick="getMessageByShowAppraisalCode();"/>
                <font id="showAppraisalCodeValid" ></font>
            </div>
        </div>
		<div class="control-group" id="hiddenDiv4">
            <label class="control-label">外国血统证书号：</label>
            <div class="controls">
                <input type="text"id="overseasPedigreeCertified"  name="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
                <input class="btn btn-primary" type="button" value="查" onclick="getMessageByOverseasPedigreeCertified();"/>
                <font id="overseasPedigreeCertifiedValid" ></font>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">旧芯片号：</label>
			<div class="controls">
				<form:input path="chipCodeOld" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新芯片号：</label>
			<div class="controls">
				<form:input path="chipCodeNew" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">付款会员号：</label>
            <div class="controls">
                <form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
		<div class="form-actions">
			<shiro:hasPermission name="finance:paymentOrder:orderItem"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>