<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>排课管理</title>
<meta name="decorator" content="default" />
<script type="text/javascript">
	$(document).ready(function() {
		initList();

		$("#btnSubmit").on('click' , function(){
			var courseId = $("#courseId").val();
			var id = $("#id").val();
			// 排课类型 1:单独排课 2:批量排课
			var arrangeType = $("#arrangeType").val();
			if(courseId == ''){ alert("课程不能为空!"); return};
			
			$.ajax({
				url:'${ctx}/appreciation/appreciationApply/arrange',
				data : {
					courseId : courseId,
					id : id,
					arrangeType : arrangeType
				},
				async:true,
				loadFlag:true,
				type:'post',
				cache:false,
				success:function(json){
					if(json == "OK"){
						var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
						parent.layer.close(index);
					}else{
						alert(json);
					}
				}
			});
		});
		
		// 清空
		$("#btnCancel").on('click' , function(){
			$("#courseId").empty().val("").select2();

			var html = "<option  value=''>请选择</option>";
			<c:forEach items="${courseList}" var="course" > 
					html+="<option value='"+'${course.id}'+"' >"+ "${course.courseName}"+"</option>";
			</c:forEach>
			$("#courseId").append(html);
			$("#courseId").trigger("change");
			
		});
	});


	function initList(){
		var courseId = '${appreciationApply.courseId}';
		
		$("#courseId").empty().val("").select2();
		var html = "<option  value=''>请选择</option>";
		<c:forEach items="${courseList}" var="course" > 
				html+="<option value='"+ '${course.id}' +"' >"+ "${course.courseName}"+"</option>";
		</c:forEach>
		$("#courseId").append(html);
		$("#courseId").val(courseId);
		$("#courseId").trigger("change");
	}
</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="appreciationApply"
		action="${ctx}/appreciation/appreciationApply/save" method="post"
		class="form-horizontal">

		<form:hidden path="id" />
		<form:hidden path="arrangeType" />
		<form:hidden path="num" />

		<div class="control-group">
			<div class="controls">已选中${appreciationApply.num}条报名信息
			</div>
		</div>

		
		<div class="control-group">
			<label class="control-label">选择课程：</label>
			<div class="controls">
				<form:select id="courseId" path="courseId" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
			</div>
		</div>
		
		 <div class="form-actions">
		 	 <!-- <input id="btnCancel" class="btn btn-primary" type="button" value="清 空" /> -->
       		 <input id="btnSubmit" class="btn btn-primary" type="button" value="提 交" />
    	</div>
	</form:form>
</body>
</html>