<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/sys/user/search");
			$("#searchForm").submit();
	    	return false;
	    }
		
		function select(permissions,permissionValues){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			var userData = {
					permissions: permissions,
					permissionValues: permissionValues
			}
			if(parent.document.getElementById("mainFrame").contentWindow.officeContent.contentWindow.searchUserCallback != undefined){
				parent.document.getElementById("mainFrame").contentWindow.officeContent.contentWindow.searchUserCallback(userData);
			}
			parent.layer.close(index);
		}
	</script>
</head>
<body>
	<div style="padding:10px;">
		<form:form id="searchForm" modelAttribute="user" action="${ctx}/sys/user/search" method="post" class="breadcrumb form-search ">
			<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
			<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
			<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
			<ul class="ul-form">
				<li><label style="width: 80px;">登录名：</label><form:input path="loginName" htmlEscape="false" maxlength="50" class="input-medium"/></li>
				<li><label style="width: 80px;">姓&nbsp;&nbsp;&nbsp;名：</label><form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/></li>
				<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/></li>
				<li class="clearfix"></li>
			</ul>
		</form:form>
		<sys:message content="${message}"/>
		<table id="contentTable" class="table table-striped table-bordered table-condensed">
			<thead>
				<tr>
					<th>归属部门</th>
					<th class="sort-column login_name">登录名</th>
					<th class="sort-column name">姓名</th>
					<th>电话</th>
					<th>手机</th>
					<shiro:hasPermission name="sys:user:member:edit"><th>选择</th></shiro:hasPermission>
				</tr>
			</thead>
			<tbody>
			<c:forEach items="${page.list}" var="user">
				<tr>
					<td>${user.office.name}</td>
					<td>${user.loginName}</td>
					<td>${user.name}</td>
					<td>${user.phone}</td>
					<td>${user.mobile}</td>
					<td>
    					<a href="#" onclick="select('${user.permissions}','${user.permissionValues}');">选择</a>
					</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
		<div class="pagination">${page}</div>
	</div>
</body>
</html>