package com.cku.schools.mrschool.web;

import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.trainschool.entity.GroomerSchoolMail;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.GroomerSchoolMailService;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *user chaixueteng
 *2017年6月19日
 */
@Controller
@RequestMapping(value="/schools/schoolsAccountManagement")
public class SchoolsAccountController extends BaseController{
	
	@Autowired
	private TrainingInstitutionService trainingInstitutionService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private GroomerSchoolMailService groomerSchoolMailService;
	/**
	 * 账户管理
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/account")
	public String account(TrainingInstitution trainingInstitution,Model model){
		String id = trainingInstitution.getId();
		TrainingInstitution trainingInstitution2 = trainingInstitutionService.get(id);
		model.addAttribute("ti", trainingInstitution2);
		model.addAttribute("province",UserUtils.getProvince());
		return "schools/account/accountManagement";
	}
	
	/**
	 * 账户充值
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/recharge")
	public String recharge(Model model){
		model.addAttribute("paymentOrder", new PaymentOrder());
		return "schools/account/schoolRecharge";
	}
	
	/**
	 * 我的邮寄信息
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/myPost")
	public String myPost(GroomerSchoolMail groomerSchoolMail, HttpServletRequest request, HttpServletResponse response, Model model) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String id = ti.getId();
		groomerSchoolMail.setSchoolId(id);
		Page<GroomerSchoolMail> page = groomerSchoolMailService.findPage(new Page<GroomerSchoolMail>(request, response), groomerSchoolMail);
     	model.addAttribute("page", page);
     	model.addAttribute("ti", ti);
	    return "schools/account/groomerSchoolMailList";
	}
	/**
	 * 我的充值记录
	 * @Author chaixueteng
	 * @2016年10月9日下午4:40:28
	 */
	@RequestMapping(value="/myRecord")
	public String myRecord(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response, Model model){
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String memberCode = trainingInstitution.getSchoolMemberCode();
		paymentOrder.setMemberCode(memberCode);
		paymentOrder.setPaymentState("2");
		paymentOrder.setIsRecharge("1");
		Page<PaymentOrder> page = paymentOrderService.findPage(new Page<PaymentOrder>(request, response), paymentOrder);
		model.addAttribute("page", page);
		return "schools/account/paymentRecordList";
	}
	
	/**
	 * 我的消费记录
	 * @Author chaixueteng
	 * @2016年10月9日下午4:40:28
	 */
	@RequestMapping(value="/myConsume")
	public String myConsume(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response, Model model){
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		paymentOrder.setMemberCode(null);
		paymentOrder.setPaymentState("2");
		paymentOrder.setIsRecharge("0");
		paymentOrder.setCreateBy(trainingInstitution.getUser());
		Page<PaymentOrder> page = paymentOrderService.findPage(new Page<PaymentOrder>(request, response), paymentOrder);
		model.addAttribute("page", page);
		return "schools/account/paymentOrderList";
	}
	/**
	 * 消费记录详情
	 * @Author chaixueteng
	 * @2016年10月9日下午6:30:55
	 */
	@RequestMapping(value="/orderDetil")
	public String orderDetil(String	 id,Model model){
		PaymentOrder paymentOrder = paymentOrderService.get(id);
		model.addAttribute("paymentOrder", paymentOrder);
		return "schools/account/paymentOrderDetail";
	}
	
	
	
	/**
	 * 修改邮寄地址
	 * @Author chaixueteng
	 * @2016年10月11日上午11:40:28
	 */
	@RequestMapping(value="/updateAddress")
	@ResponseBody
	public String updateAddress(HttpServletRequest request, HttpServletResponse response){
		String id = request.getParameter("id");
		String province = request.getParameter("province");
		String city = request.getParameter("city");
		String street = request.getParameter("street");
		TrainingInstitution ti = trainingInstitutionService.get(id);
		ti.setProvince(province);
		ti.setCity(city);
		ti.setStreet(street);
		ti.setAddress(province+city+street);
		trainingInstitutionService.save(ti);
		String address = ti.getAddress();
		return "{\"rc\":true,\"address\":\""+address+"\"}";
	}

	//
}
