package com.cku.restful.v1.sys.web;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jdom.JDOMException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentPayLog;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentPayLogService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.utils.WeChatUtils;
import com.cku.util.JSONUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.XMLUtil;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.AutoUpdateCertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * 微信支付的接口，底层依赖于php的支付接口
 *
 * @author fanhuibin
 */
@Slf4j
@Controller
@RequestMapping(value = "/api/v1/open/wxpay")
public class WeixinPayController extends BaseRestController {
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private RestShowApplyService restShowApplyService;
	@Autowired
	private PaymentPayLogService paymentPayLogService;

	/**
	 * 公共参数
	 */
	private static String CURRENT_MODE;

	/**
	 * 商户信息
	 */
	private static String MCH_ID;
	private static String APP_ID;
	private static String MCH_SERIALNO;
	private static String APIV3_KEY;
	private static String PRIVATE_KEY_PATH;
	private static String NOTIFY_URL;
	private static PrivateKey merchantPrivateKey = null;

	static {
		CURRENT_MODE = Global.getConfig("mode");
		MCH_ID = Global.getConfig("wechat.pay.mch_id");
		APP_ID = Global.getConfig("wechat.pay.app_id");
		MCH_SERIALNO = Global.getConfig("wechat.pay.mch_serialno");
		APIV3_KEY = Global.getConfig("wechat.pay.apiv3_key");
		PRIVATE_KEY_PATH = Global.getConfig("wechat.pay.private_key_path");
		NOTIFY_URL = Global.getConfig("wechat.pay.notify_url");
		merchantPrivateKey = PemUtil.loadPrivateKey(WeixinPayController.class.getResourceAsStream(PRIVATE_KEY_PATH));
	}

	private Logger logger = LoggerFactory.getLogger(WeixinPayController.class);

	@RequestMapping(value = "/pay/{orderId}")
	public void pay(@PathVariable String orderId, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// 判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		// 如果订单已删除。报错提示
		if (order != null && "1".equals(order.getDelFlag())) {
			BufferedImage image = ImageIO
					.read(new FileInputStream(WeixinPayController.class.getResource("/").getPath() + "wxPayWarn.png"));
			// 输出png图片
			ImageIO.write(image, "png", response.getOutputStream());
			return;
		}
		if (order != null && "1".equals(order.getPaymentState())) {
			// 订单是可用订单，什么都不做
			// 支付宝、微信支付不允许支付包含赛事报名的订单
			if (restShowApplyService.isShowApplyOrder(order)) {
				BufferedImage image = ImageIO.read(
						new FileInputStream(WeixinPayController.class.getResource("/").getPath() + "wxPayWarn2.png"));
				// 输出png图片
				ImageIO.write(image, "png", response.getOutputStream());
				return;
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单验证失败");
		}
		// 设置支付金额，单位是分
		int totalAmount = new BigDecimal(order.getTotalPrice()).multiply(new BigDecimal("100")).intValue();
		if ("dev".equals(CURRENT_MODE)) {
			totalAmount = 1;
		}
		// 申请微信支付
		// 构建httpclient
		AutoUpdateCertificatesVerifier verifier = new AutoUpdateCertificatesVerifier(
				new WechatPay2Credentials(MCH_ID, new PrivateKeySigner(MCH_SERIALNO, merchantPrivateKey)),
				APIV3_KEY.getBytes(StandardCharsets.UTF_8));
		CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create()
				.withMerchant(MCH_ID, MCH_SERIALNO, merchantPrivateKey).withValidator(new WechatPay2Validator(verifier))
				.build();
		HttpPost httpPost = new HttpPost(WeChatUtils.WX_TRANSACTIONS_HOST + WeChatUtils.WX_TRANSACTIONS_URI);
		httpPost.addHeader("Accept", "application/json");
		httpPost.addHeader("Content-type", "application/json; charset=utf-8");
		// 设置参数
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		ObjectMapper objectMapper = new ObjectMapper();
		ObjectNode rootNode = objectMapper.createObjectNode();
		rootNode.put("mchid", MCH_ID).put("appid", APP_ID).put("description", "CKU业务订单支付").put("notify_url", NOTIFY_URL)
				.put("out_trade_no", orderId)
				.put("time_expire", DateUtils.parseDateByRFC3339(DateUtils.getMinuteLater(new Date(), 5)));
		rootNode.putObject("amount").put("total", totalAmount);
		objectMapper.writeValue(bos, rootNode);
		// 生成支付订单
		httpPost.setEntity(new StringEntity(bos.toString("UTF-8"), "UTF-8"));
		CloseableHttpResponse resp = httpClient.execute(httpPost);
		
		int statusCode = resp.getStatusLine().getStatusCode();
		try {
			// 处理成功
			if (statusCode == 200) {
				String resString = EntityUtils.toString(resp.getEntity());
				String codeUrl = JSONObject.fromObject(resString).getString("code_url");
				// 生成支付二维码
				int width = 300;
				int height = 300;
				Hashtable hints = new Hashtable();
				hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
				BitMatrix bitMatrix = new MultiFormatWriter().encode(codeUrl, BarcodeFormat.QR_CODE, width, height,
						hints);
				MatrixToImageWriter.writeToStream(bitMatrix, "png", response.getOutputStream());
				// 增加支付日志
				paymentPayLogService.savePayLog(order.getId(), "24");
			} else if (statusCode == 204) {
				logger.error("statusCode:",statusCode);
				logger.error( EntityUtils.toString(resp.getEntity()));
				throw new ZAException(ZAErrorCode.ZA_ERROR, "生成支付信息失败，请重试！");
			} else {
				logger.error("statusCode:",statusCode);
				logger.error( EntityUtils.toString(resp.getEntity()));
				throw new ZAException(ZAErrorCode.ZA_ERROR, "生成支付信息失败，请重试");
			}
		} finally {
			// 关闭资源
			resp.close();
			httpClient.close();
		}
	}

	@Autowired
	private RedissonClient redissonClient;

	@RequestMapping(value = "/notifyUrl")
	public void notify(@RequestBody String body, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		boolean resultFlag = false;
		RLock rLock = null;
		try {
			logger.info("微信支付回调开始:" + body);
			JSONObject resourceJsonObj = JSONObject.fromObject(body).getJSONObject("resource");
			String associatedData = resourceJsonObj.getString("associated_data");
			String nonce = resourceJsonObj.getString("nonce");
			String ciphertext = resourceJsonObj.getString("ciphertext");
			AesUtil aesUtil = new AesUtil(APIV3_KEY.getBytes(StandardCharsets.UTF_8));
			String decryptToString = aesUtil.decryptToString(associatedData.getBytes(StandardCharsets.UTF_8),
					nonce.getBytes(StandardCharsets.UTF_8), ciphertext);
			JSONObject resultJsonObj = JSONObject.fromObject(decryptToString);
			// 验签
			if ("SUCCESS".equals(resultJsonObj.getString("trade_state"))) {
				String orderId = resultJsonObj.getString("out_trade_no");
				String transactionId = resultJsonObj.getString("transaction_id");
				rLock = redissonClient.getFairLock(orderId + "_" + transactionId);
				// 活锁避免死锁
				rLock.lock(5, TimeUnit.MINUTES);
				logger.info("锁开始:" + DateUtils.formatDateTime(new Date()));
				try {
					PaymentOrder order = paymentOrderService.get(orderId);
					if (order != null && "1".equals(order.getPaymentState())
							&& !StringUtils.isEmpty(order.getOrderCode())) {
						// 保存回调的支付日志和支付方式
						paymentPayLogService.updatePayInfo(orderId, transactionId, decryptToString, "24");
						// 后台添加功能-现场微信支付 代码修改-lyy
						if (!"28".equals(order.getPaymentWay())) {
							// 24代表微信支付
							order.setPaymentWay("24");
						}
						// 修改第三方订单号
						order.setTransactionId(transactionId);
						long current = System.currentTimeMillis();
						logger.info("处理支付回调业务处理 Start===============" + current);
						// 会员端支付后处理逻辑
						restOrderService.afterPay(order);
						logger.info("处理支付回调业务处理 End===============" + (System.currentTimeMillis() - current));
						// 修改支付日志支付状态
						paymentPayLogService.updatePayState(orderId, "2", null);
						resultFlag = true;
					} else if (order != null && "2".equals(order.getPaymentState())
							&& !StringUtils.isEmpty(order.getOrderCode())) {
						logger.info("用户支付成功，订单已经处理过");
						resultFlag = true;
					} else {
						logger.error("用户支付成功，但是处理失败，没有找到待处理订单");
						// 保存回调的支付日志和支付方式
						paymentPayLogService.updatePayInfo(orderId, transactionId, decryptToString, "24");
						// 修改支付日志支付状态
						paymentPayLogService.updatePayState(orderId, "3", "用户支付成功，但是处理失败，没有找到待处理订单,原始回调参数：" + body);
					}
				} catch (Exception e) {
					logger.error("微信支付，回调业务处理失败。", e);
					// 修改支付日志支付状态
					paymentPayLogService.updatePayState(orderId, "3", ExceptionUtil.printStackTrace(e));
				}
			} else {
				logger.error("微信支付，签名校验失败。");
			}
		} catch (Exception e) {
			logger.error("微信支付回调失败。", e);
		} finally {
			if (Objects.nonNull(rLock)) {
				rLock.unlock();
				logger.info("锁结束:" + DateUtils.formatDateTime(new Date()));
			}
			wxCallbackResultHandle(response, resultFlag);
		}
	}
	
//  支付回调的备选方案
//	@Autowired
//	private PayCallBackTaskService payCallBackTaskService;
//	
//	@RequestMapping(value = "/notifyUrl")
//	public void notify(@RequestBody String body, HttpServletRequest request, HttpServletResponse response)
//			throws Exception {
//		String rdsKey = "";
//		try {
//			JSONObject resourceJsonObj = JSONObject.fromObject(body).getJSONObject("resource");
//			String associatedData = resourceJsonObj.getString("associated_data");
//			String nonce = resourceJsonObj.getString("nonce");
//			String ciphertext = resourceJsonObj.getString("ciphertext");
//			String decryptToString = new AesUtil(APIV3_KEY.getBytes(StandardCharsets.UTF_8)).decryptToString(
//					associatedData.getBytes(StandardCharsets.UTF_8), nonce.getBytes(StandardCharsets.UTF_8),
//					ciphertext);
//			JSONObject resultJsonObj = JSONObject.fromObject(decryptToString);
//			// 验签
//			if ("SUCCESS".equals(resultJsonObj.getString("trade_state"))) {
//				String orderId = resultJsonObj.getString("out_trade_no");
//				String transactionId = resultJsonObj.getString("transaction_id");
//				rdsKey = MD5Util.MD5Encode(orderId + "_" + transactionId,"UTF-8") ;
//				// 由于微信V3版本支付完成回调时，第一次为了保证商家端能收到回调通知，会发送多路调用，此处限制第一个3秒内只处理其中一次
//				// 如果处理失败，微信回调机制会按照 1s/15s/15s/30s/60s...等机制再次回调
//				if (Objects.nonNull(JedisUtils.getResource().set(rdsKey, "false", "NX", "EX", 3))) {
//					// 异步处理回调结果
//					payCallBackTaskService.payCallBack(rdsKey, orderId, transactionId, decryptToString);
//				}
//			} else {
//				log.error("微信支付，签名校验失败。");
//			}
//
//		} catch (Exception e) {
//			e.printStackTrace();
//		} finally {
//			// 微信通知处理结果V3版本，不在使用返回值确认，而是通过HTTP的状态码确认，故未处理成功均返回状态码500
//			wxCallbackResultHandle(response, Boolean.valueOf(JedisUtils.getResource().get(rdsKey)));
//		}
//	}

	private void wxCallbackResultHandle(HttpServletResponse response, boolean isSuccess) throws IOException {
		if (isSuccess) {
			Map<String, String> sucMap = new HashMap<>();
			sucMap.put("code", "SUCCESS");
			sucMap.put("message", "OK");
			response.getWriter().write(JSONUtils.toJSON(sucMap));
			log.info("微信支付异步通知回调成功的消息回复结束");
		} else {
			Map<String, String> failMap = new HashMap<>();
			failMap.put("code", "FAIL");
			failMap.put("message", "ERROR");
			// 微信通知处理结果V3版本，不在使用返回值确认，而是通过HTTP的状态码确认，故未处理成功均返回状态码500
			response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			// 微信通知处理结果V3版本，不在使用返回值确认，而是通过HTTP的状态码确认，故未处理成功均返回状态码500
			response.getWriter().write(JSONUtils.toJSON(failMap));
			log.info("微信支付异步通知回调失败的消息回复结束");
		}
	}

	/**
	 * 补充方法 传入paylog id 可自动处理支付失败订单
	 *
	 * @param id
	 * @throws JDOMException
	 * @throws IOException
	 */
	@RequestMapping(value = "/test")
	@ResponseBody
	public void test(String id) throws JDOMException, IOException {
		PaymentPayLog log = paymentPayLogService.get(id);
		String body = log.getPayInfo();
		try {
			logger.info("微信支付回调开始:" + body);
			
			JSONObject map = JSONObject.fromObject(body);
//			Map map = XMLUtil.doXMLParse(body);
			String orderId = (String) map.get("out_trade_no");
			String transactionId = (String) map.get("transaction_id");
			// 更新支付方式
			paymentPayLogService.updatePayType(orderId, "24");
			try {
				PaymentOrder order = paymentOrderService.get(orderId);
				if (order != null && order.getPaymentState().equals("1")
						&& !StringUtils.isEmpty(order.getOrderCode())) {
					// 后台添加功能-现场微信支付 代码修改-lyy
					if (!"28".equals(order.getPaymentWay())) {
						order.setPaymentWay("24");// 24代表微信支付
					}
					// 修改第三方订单号
					order.setTransactionId(transactionId);
					long current = System.currentTimeMillis();
					logger.info("处理支付回调业务处理 Start===============" + current);
					// 会员端支付后处理逻辑
					restOrderService.afterPay(order);
					logger.info("处理支付回调业务处理 End===============" + (System.currentTimeMillis() - current));
					// 修改支付日志支付状态
					paymentPayLogService.updatePayState(orderId, "2", null);
				} else if (order != null && order.getPaymentState().equals("2")
						&& !StringUtils.isEmpty(order.getOrderCode())) {
					logger.info("用户支付成功，订单已经处理过");
				} else {
					logger.error("用户支付成功，但是处理失败，没有找到待处理订单");
					// 修改支付日志支付状态
					paymentPayLogService.updatePayState(orderId, "3", "用户支付成功，但是处理失败，没有找到待处理订单");
				}
			} catch (Exception e) {
				logger.error("微信支付，回调业务处理失败。", e);
				// 修改支付日志支付状态
				paymentPayLogService.updatePayState(orderId, "3", ExceptionUtil.printStackTrace(e));
			}
		} catch (Exception e) {
			logger.error("微信支付回调失败。", e);
		}
	}

}
