/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.open;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.modules.sys.dao.AreaDao;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 培训机构管理Controller
 *
 * @author laiguanglong
 * @version 2018-12-27
 */
@Controller
@RequestMapping(value = "/api/v1/open/area")
public class OpenAreaController extends BaseRestController {

    public static final Map<String, String> PROVINCE_CITY_MAP = new ImmutableMap.Builder<String, String>()
            .put("3", "北京市")
            .put("4", "上海市")
            .put("5", "天津市")
            .put("6", "重庆市")
            .build();

    @Autowired
    private AreaDao areaDao;

    @RequestMapping(value = "/getProvince", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse getProvince() throws IOException {
        List<JSONObject> list = Lists.newArrayList();
        for (Area area : areaDao.getProvince()) {
            JSONObject vo = new JSONObject();
            vo.put("id", area.getId());
            vo.put("name", area.getName());
            list.add(vo);
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

    @RequestMapping(value = "/getCityByParentId/{parentId}", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse getCityByParentId(@PathVariable("parentId") String parentId) throws IOException {
        List<JSONObject> list = Lists.newArrayList();
        if (PROVINCE_CITY_MAP.containsKey(parentId)) {
            JSONObject vo = new JSONObject();
            vo.put("parentId", parentId);
            vo.put("name", PROVINCE_CITY_MAP.get(parentId));
            list.add(vo);
        } else {
            for (Area area : areaDao.getCityByParentId(parentId)) {
                JSONObject vo = new JSONObject();
                vo.put("parentId", parentId);
                vo.put("name", area.getName());
                list.add(vo);
            }
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

}
